/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.dataloader;

import com.ebmwebsourcing.petalsview.service.dataloader.DataLoaderException;
import com.ebmwebsourcing.webcommons.util.JAXBUtil;
import com.petalsview.dataset.Dataset;
import com.petalsview.dataset.ObjectFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;

public class ViewDatasetHandler {
    private static ViewDatasetHandler instance;
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    private static final List<Class> defaultObjectFactories;

    private ViewDatasetHandler() throws DataLoaderException {
        try {
            JAXBContext context = JAXBUtil.createJAXBContext(defaultObjectFactories);
            unmarshaller = context.createUnmarshaller();
            marshaller = context.createMarshaller();
        }
        catch (JAXBException e) {
            throw new DataLoaderException(e);
        }
    }

    public Dataset convertStreamSource2ViewDataset(Source datasetStream) throws DataLoaderException {
        try {
            JAXBElement wsdlBinding = unmarshaller.unmarshal(datasetStream, Dataset.class);
            return (Dataset)wsdlBinding.getValue();
        }
        catch (JAXBException e) {
            throw new DataLoaderException("Failed to build Java bindings from dataset XML document", e);
        }
    }

    public static ViewDatasetHandler getInstance() throws DataLoaderException {
        if (instance == null) {
            instance = new ViewDatasetHandler();
        }
        return instance;
    }

    static {
        defaultObjectFactories = new ArrayList<Class>(Arrays.asList(ObjectFactory.class));
    }
}

