/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.flow;

import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowStepDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowRefDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowStepRefDAO;
import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.service.flow.FlowException;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="flowManager")
public class FlowManagerImpl
implements FlowManager {
    @Resource(name="flowDAO")
    private FlowDAO flowDAO;
    @Resource(name="flowStepDAO")
    private FlowStepDAO flowStepDAO;
    @Resource(name="flowStepRefDAO")
    private FlowStepRefDAO flowStepRefDAO;
    @Resource(name="flowRefDAO")
    private FlowRefDAO flowRefDAO;
    @Resource(name="flowManager")
    private FlowManager flowManager;

    @Override
    public Flow load(String id) throws FlowException {
        if (id == null) {
            throw new FlowException("no flow whith this id in database ! ");
        }
        Flow flow = this.flowDAO.loadByPetalsId(id);
        if (flow == null) {
            throw new FlowException("no flow whith this id in database ! ");
        }
        this.updateFlowStatusAndDates(flow);
        return flow;
    }

    @Override
    public int[] getAllFlowReferentialType() {
        List listFlowRef = this.flowRefDAO.getAll();
        int[] allTypes = new int[listFlowRef.size()];
        for (int i = 0; i < listFlowRef.size(); ++i) {
            allTypes[i] = ((FlowRef)listFlowRef.get(i)).getType();
        }
        return allTypes;
    }

    @Override
    public String saveOrUpdate(Flow flow) throws FlowException {
        if (flow == null) {
            throw new FlowException("no flow whith this id in database ! ");
        }
        this.flowDAO.save((Object)flow);
        String result = flow.getIdpetals();
        return result;
    }

    @Override
    public List<Flow> loadAll() {
        List result = this.flowDAO.loadAll();
        return result;
    }

    @Override
    public List<Flow> loadAllStarted() {
        List result = this.flowDAO.loadAllStarted();
        if (result != null) {
            for (Flow flow : result) {
                this.updateFlowStatusAndDates(flow);
            }
        }
        return result;
    }

    @Override
    public List<Flow> loadUnknowsFlows() {
        List listTmp = this.flowRefDAO.getAll();
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (FlowRef fR : listTmp) {
            types.add(fR.getType());
        }
        List result = this.flowDAO.loadUnknowsFlow(types);
        for (int i = 0; i < result.size(); ++i) {
            int j = i + 1;
            while (j < result.size()) {
                if (((Flow)result.get(i)).getType() == ((Flow)result.get(j)).getType()) {
                    result.remove(j);
                    continue;
                }
                ++j;
            }
        }
        return result;
    }

    @Override
    public List<Flow> loadByType(int type) {
        List result = this.flowDAO.loadByType(type);
        if (result != null) {
            for (Flow flow : result) {
                this.updateFlowStatusAndDates(flow);
            }
        }
        return result;
    }

    @Override
    public List<Flow> loadAllStartedByType(int type) {
        List result = this.flowDAO.loadAllStartedByType(type);
        if (result != null) {
            for (Flow flow : result) {
                this.updateFlowStatusAndDates(flow);
            }
        }
        return result;
    }

    @Override
    public List<Flow> loadAllStartedByTypeWithDateFilter(int type, Date startDate, Date endDate) {
        List result = this.flowDAO.loadAllStartedByTypeWithDateFilter(type, startDate, endDate);
        if (result != null) {
            for (Flow flow : result) {
                this.updateFlowStatusAndDates(flow);
            }
        }
        return result;
    }

    @Override
    public List<Flow> loadAllStartedWithDateFilter(Date startDate, Date endDate) {
        List result = this.flowDAO.loadAllStartedWithDateFilter(startDate, endDate);
        return result;
    }

    @Override
    public void remove(String id) throws FlowException {
        if (id == null) {
            throw new FlowException("no flow whith this id in database ! ");
        }
        Flow flow = this.flowDAO.loadByPetalsId(id);
        if (flow == null) {
            throw new FlowException("no flow whith this petals id in database ! ");
        }
        this.flowDAO.remove((Object)flow);
    }

    @Override
    public void removeOldFlow(int type) throws FlowException {
        FlowRef flowRef = this.flowRefDAO.loadByType(type);
        int referenceTime = flowRef.getReferenceTime();
        long d = this.createLongDate(referenceTime);
        Date da = new Date();
        da.setTime(d);
        boolean containRows = true;
        while (containRows) {
            containRows = this.flowManager.removeByBlock(d, type);
        }
    }

    @Override
    public boolean removeByBlock(long d, int type) {
        List listFlows = this.flowDAO.getFlowsByDateAndType(d, type);
        if (listFlows == null || listFlows.isEmpty()) {
            return false;
        }
        for (Flow f : listFlows) {
            Flow fl = (Flow)this.flowDAO.get((Serializable)f.getId());
            this.flowDAO.remove((Object)fl);
        }
        return true;
    }

    private long createLongDate(int referenceTime) {
        Calendar cal = Calendar.getInstance();
        Date date = new Date();
        cal.setTime(date);
        int day = cal.get(6) - referenceTime;
        cal.set(6, day);
        cal.set(10, 12);
        cal.set(12, 0);
        cal.set(13, 1);
        date = cal.getTime();
        long d = date.getTime();
        return d;
    }

    private void updateFlowStatusAndDates(Flow flow) {
        FlowStepRef startStepRef;
        List flowSteps;
        FlowStepRef endStepRef = this.flowStepRefDAO.loadEndStepByFlowType(flow.getType());
        if (endStepRef != null && (flowSteps = this.flowStepDAO.loadByFlowIdAndMeProps(flow.getIdpetals(), endStepRef.getInterfaceName(), endStepRef.getServiceName())) != null && flowSteps.size() == 1) {
            flow.setStatus(Integer.valueOf(((FlowStep)flowSteps.get(0)).getStatus()));
            flow.setEndDate(((FlowStep)flowSteps.get(0)).getEndDate());
        }
        if ((startStepRef = this.flowStepRefDAO.loadStartStepByFlowType(flow.getType())) != null) {
            List flowSteps2 = this.flowStepDAO.loadByFlowIdAndMeProps(flow.getIdpetals(), startStepRef.getInterfaceName(), startStepRef.getServiceName());
            if (flowSteps2 != null && flowSteps2.size() == 1) {
                flow.setStartDate(((FlowStep)flowSteps2.get(0)).getStartDate());
            }
        } else {
            flow.setStatus(Integer.valueOf(-1));
        }
    }
}

