/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.flow;

import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowStepDAO;
import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.service.flow.FlowException;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="flowStepManager")
public class FlowStepManagerImpl
implements FlowStepManager {
    @Resource(name="flowDAO")
    private FlowDAO flowDAO;
    @Resource(name="flowStepDAO")
    private FlowStepDAO flowStepDAO;

    @Override
    public FlowStep loadFlowStep(String flowStepId) throws FlowException {
        if (flowStepId == null) {
            throw new FlowException("no flow step whith this id in database ! ");
        }
        FlowStep result = (FlowStep)this.flowStepDAO.get((Serializable)((Object)flowStepId));
        return result;
    }

    @Override
    public FlowStep loadFlowStep(String flowId, String meUUID, String interfaceName, String serviceName, String endpointName) {
        FlowStep result = this.flowStepDAO.loadByMeUUID(meUUID);
        return result;
    }

    @Override
    public List<FlowStep> loadSteps(String id, int type) throws FlowException {
        List flows;
        List result = new ArrayList();
        result = id != null ? this.flowStepDAO.loadByFlowId(id) : ((flows = this.flowDAO.loadByType(type)) != null && !flows.isEmpty() ? this.flowStepDAO.loadByFlowId(((Flow)flows.get(0)).getIdpetals()) : null);
        return result;
    }

    @Override
    public List<FlowStep> loadRunningSteps(String flowId) throws FlowException {
        if (flowId == null) {
            throw new FlowException("no flow step whith this id in database ! ");
        }
        List result = this.flowStepDAO.loadRunningByFlowId(flowId);
        return result;
    }

    @Override
    public List<FlowStep> loadFlowSteps(String flowId, String interfaceName, String serviceName) {
        List result = this.flowStepDAO.loadByFlowIdAndMeProps(flowId, interfaceName, serviceName);
        return result;
    }

    @Override
    public List<String> loadUnknownParameters(String interfaceName, String serviceName) {
        List result = this.flowStepDAO.loadByFlowIdAndMeProps(null, interfaceName, serviceName);
        List<String> unknownParameters = new ArrayList<String>();
        if (result != null && !result.isEmpty()) {
            for (int i = 0; i < result.size(); ++i) {
                if (((FlowStep)result.get(i)).getParameters() != null && !((FlowStep)result.get(i)).getParameters().isEmpty()) {
                    unknownParameters = ((FlowStep)result.get(i)).getParameters();
                    break;
                }
                if (((FlowStep)result.get(i)).getParameters() != null || i != result.size()) continue;
                unknownParameters = null;
            }
        }
        return unknownParameters;
    }

    @Override
    public void removeStep(String flowId, String meUUID, String interfaceName, String serviceName, String endpointName) throws FlowException {
        FlowStep flowStep = this.flowStepDAO.loadByMeUUID(meUUID);
        if (flowStep == null) {
            throw new FlowException("no flow step whith this petals id in database ! ");
        }
        this.flowStepDAO.remove((Object)flowStep);
    }

    @Override
    public void addStep(Flow flow, FlowStep flowStep) {
        flowStep.setFlow(flow);
        this.flowStepDAO.save((Object)flowStep);
    }

    @Override
    public void updateStep(FlowStep flowStep) {
        this.flowStepDAO.save((Object)flowStep);
    }
}

