/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.flowref;

import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowStepDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowParamsDetails;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowRefDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowStepRefDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowWithParams;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.GlobalFlowParam;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="flowRefManager")
public class FlowRefManagerImpl
implements FlowRefManager {
    @Resource(name="flowRefDAO")
    private FlowRefDAO flowRefDAO;
    @Resource(name="flowStepRefDAO")
    private FlowStepRefDAO flowStepRefDAO;
    @Resource(name="flowStepDAO")
    private FlowStepDAO flowStepDAO;

    @Override
    public FlowRef getFlowRef(int type) {
        FlowRef result = this.flowRefDAO.loadByType(type);
        return result;
    }

    @Override
    public FlowRef loadFlowRef(String id) throws FlowRefException {
        if (id == null) {
            throw new FlowRefException("you must specify a valid flow referential id ");
        }
        FlowRef result = (FlowRef)this.flowRefDAO.get((Serializable)((Object)id));
        if (result == null) {
            throw new FlowRefException("you must specify a valid flow referential id ");
        }
        return result;
    }

    @Override
    public List<String> loadAllServiceName() {
        List allSteps = this.flowStepDAO.getAllOrderByServiceName();
        List<String> allServiceName = new ArrayList<String>();
        if (allSteps != null && !allSteps.isEmpty()) {
            for (FlowStep fS : allSteps) {
                String name = fS.getServiceName();
                allServiceName.add(name);
            }
        }
        allServiceName = this.sortList(allServiceName);
        return allServiceName;
    }

    @Override
    public List<String> loadAllInterfaceName() {
        List allSteps = this.flowStepDAO.getAll();
        List<String> allInterfaceName = new ArrayList<String>();
        if (allSteps != null && !allSteps.isEmpty()) {
            for (FlowStep fS : allSteps) {
                String name = fS.getInterfaceName();
                allInterfaceName.add(name);
            }
        }
        allInterfaceName = this.sortList(allInterfaceName);
        return allInterfaceName;
    }

    @Override
    public List<String> loadAllEndpointName() {
        List allSteps = this.flowStepDAO.getAll();
        ArrayList<String> allEndpointName = new ArrayList<String>();
        if (allSteps != null && !allSteps.isEmpty()) {
            for (FlowStep fS : allSteps) {
                String name = fS.getEndpointName();
                allEndpointName.add(name);
            }
        }
        return allEndpointName;
    }

    @Override
    public List<FlowRef> loadAll() {
        List result = this.flowRefDAO.getAll();
        return result;
    }

    @Override
    public String createFlowRef(int type, String name) throws FlowRefException {
        FlowRef flowRef = new FlowRef();
        flowRef.setName(name);
        flowRef.setType(type);
        flowRef.setReferenceTime(Integer.valueOf(0));
        flowRef.setCreationDate(new Date());
        FlowRef tmp = this.flowRefDAO.loadByType(flowRef.getType());
        this.verification(flowRef, tmp);
        this.flowRefDAO.save((Object)flowRef);
        String id = flowRef.getId();
        return id;
    }

    @Override
    public void update(FlowRef flowRef) throws FlowRefException {
        FlowRef tmp = this.flowRefDAO.loadByType(flowRef.getType());
        this.verification(flowRef, tmp);
        tmp.setName(flowRef.getName());
        tmp.setReferenceTime(Integer.valueOf(flowRef.getReferenceTime()));
        this.flowRefDAO.save((Object)tmp);
    }

    @Override
    public void removeFlowRef(int[] flowRefTypes) throws FlowRefException {
        if (flowRefTypes == null) {
            throw new FlowRefException("you must specify a valid flow referential id ");
        }
        for (int type : flowRefTypes) {
            this.removeFlowRef(type);
        }
    }

    @Override
    public void removeFlowRef(int type) throws FlowRefException {
        List steps = this.flowStepRefDAO.loadByFlowType(type);
        if (steps != null) {
            for (FlowStepRef step : steps) {
                this.flowStepRefDAO.remove((Object)step);
            }
        }
        this.flowRefDAO.remove((Object)this.flowRefDAO.loadByType(type));
    }

    private List<String> sortList(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            int j = i + 1;
            while (j < list.size()) {
                if (list.get(i).equals(list.get(j))) {
                    list.remove(j);
                    continue;
                }
                ++j;
            }
        }
        return list;
    }

    private void verification(FlowRef flowRef, FlowRef tmp) throws FlowRefException {
        if (flowRef.getName() == null) {
            throw new FlowRefException("You must specify a flow referential name ");
        }
        if (flowRef.getId() != null) {
            if (tmp != null && !flowRef.getId().equals(tmp.getId())) {
                throw new FlowRefException("A flow referential with that type already exists : " + flowRef.getType());
            }
            FlowRef fr = new FlowRef();
            fr = this.flowRefDAO.loadByName(flowRef.getName());
            if (fr != null && !fr.getId().equals(flowRef.getId())) {
                throw new FlowRefException("A flow referential with that name already exists : " + flowRef.getName());
            }
        } else {
            if (tmp != null) {
                throw new FlowRefException("A flow referential with that type already exists : " + flowRef.getType());
            }
            tmp = new FlowRef();
            tmp = this.flowRefDAO.loadByName(flowRef.getName());
            if (tmp != null) {
                throw new FlowRefException("A flow referential with that name already exists : " + flowRef.getName());
            }
        }
    }

    @Override
    public List<GlobalFlowParam> getGlobalFlowParameters(short flowType) {
        List result = this.flowStepRefDAO.getGlobalFlowParameters(flowType);
        return result;
    }

    @Override
    public List<FlowWithParams> getFlowsWithParameters(List<GlobalFlowParam> globalParams, short type, Date after, Date before) {
        List result = this.flowStepRefDAO.getFlowsWithParameters(globalParams, type, after, before);
        return result;
    }

    @Override
    public List<FlowParamsDetails> getDetailFlowParameter(short flowType, String flowId) throws FlowRefException {
        if (flowId == null) {
            throw new FlowRefException("You must specify a flow : ");
        }
        List result = this.flowStepRefDAO.getDetailFlowParameter(flowType, flowId);
        return result;
    }
}

