/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.flowref;

import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowStepErrorRefDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowStepRefDAO;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.StepParameter;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManagerRuntimeException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="flowStepRefManager")
public class FlowStepRefManagerImpl
implements FlowStepRefManager {
    @Resource(name="flowStepRefDAO")
    private FlowStepRefDAO flowStepRefDAO;
    @Resource(name="flowStepErrorRefDAO")
    private FlowStepErrorRefDAO flowStepErrorRefDAO;
    @Resource(name="flowRefManager")
    private FlowRefManager flowRefManager;

    @Override
    public List<FlowStepRef> loadSteps(int type) {
        List result = this.flowStepRefDAO.loadByFlowType(type);
        return result;
    }

    @Override
    public FlowStepRef loadStepRef(int type, String interfaceName, String serviceName) throws FlowRefException {
        if (interfaceName == null) {
            throw new FlowRefException("You must specify a flow step referential interface name ");
        }
        if (serviceName == null) {
            throw new FlowRefException("You must specify a flow step referential service name ");
        }
        FlowStepRef result = this.flowStepRefDAO.loadByFlowTypeIntNameServName(type, interfaceName, serviceName);
        return result;
    }

    @Override
    public FlowStepRef loadStepRef(String id) throws FlowRefException {
        if (id == null) {
            throw new FlowRefException("You must specify a flow step referential id ");
        }
        FlowStepRef result = (FlowStepRef)this.flowStepRefDAO.get((Serializable)((Object)id));
        return result;
    }

    @Override
    public void removeStepRefs(String[] ids) throws FlowRefException {
        if (ids == null) {
            throw new FlowRefException("You must specify a flow step referential id ");
        }
        for (String id : ids) {
            this.flowStepRefDAO.remove(this.flowStepRefDAO.get((Serializable)((Object)id)));
        }
    }

    @Override
    public String saveOrUpdateStepRef(FlowStepRef flowStepRef) throws FlowRefException {
        if (flowStepRef == null) {
            throw new FlowRefException("You must specify a flow step referential");
        }
        FlowStepRef flowStepRefTmp = new FlowStepRef();
        if (flowStepRef.getId() != null) {
            flowStepRefTmp = (FlowStepRef)this.flowStepRefDAO.get((Serializable)((Object)flowStepRef.getId()));
        } else {
            flowStepRefTmp.setFlowStartStep(false);
            flowStepRefTmp.setFlowEndStep(false);
        }
        this.verification(flowStepRef, flowStepRefTmp);
        this.verificationdate(flowStepRef, flowStepRefTmp);
        flowStepRefTmp.setInterfaceName(flowStepRef.getInterfaceName());
        flowStepRefTmp.setName(flowStepRef.getName());
        flowStepRefTmp.setServiceName(flowStepRef.getServiceName());
        flowStepRefTmp.setFlowref(flowStepRef.getFlowref());
        flowStepRefTmp.setFlowStartStep(flowStepRef.isFlowStartStep());
        flowStepRefTmp.setFlowEndStep(flowStepRef.isFlowEndStep());
        flowStepRefTmp.setSuccessMessage(flowStepRef.getSuccessMessage());
        flowStepRefTmp.setDefaultErrorMessage(flowStepRef.getDefaultErrorMessage());
        this.flowStepRefDAO.save((Object)flowStepRefTmp);
        String result = flowStepRefTmp.getId();
        return result;
    }

    @Override
    public FlowStepErrorRef loadStepErrorRef(String id) throws FlowRefException {
        if (id == null) {
            throw new FlowRefException("You must specify a flow step error referential id ");
        }
        FlowStepErrorRef result = (FlowStepErrorRef)this.flowStepErrorRefDAO.get((Serializable)((Object)id));
        return result;
    }

    @Override
    public List<FlowStepErrorRef> loadStepRefErrors(String stepRefId) throws FlowRefException {
        if (stepRefId == null) {
            throw new FlowRefException("You must specify a flow step referential id ");
        }
        List result = this.flowStepErrorRefDAO.loadByStepRefId(stepRefId);
        return result;
    }

    @Override
    public String saveOrUpdateErrorRef(FlowStepErrorRef stepErrorRef) throws FlowRefException {
        FlowStepErrorRef stepErrorRefTmp = this.flowStepErrorRefDAO.loadByErrorCode(stepErrorRef.getErrorCode());
        this.verificationErrorRef(stepErrorRef, stepErrorRefTmp);
        if (stepErrorRefTmp == null) {
            stepErrorRefTmp = new FlowStepErrorRef();
        }
        stepErrorRefTmp.setErrorCode(stepErrorRef.getErrorCode());
        stepErrorRefTmp.setMessage(stepErrorRef.getMessage());
        stepErrorRefTmp.setFlowstepref(stepErrorRef.getFlowstepref());
        this.flowStepErrorRefDAO.save((Object)stepErrorRefTmp);
        String result = stepErrorRefTmp.getId();
        return result;
    }

    @Override
    public void removeErrorRefs(String[] ids) throws FlowRefException {
        if (ids == null) {
            throw new FlowRefException("you must specify valid flow step error referential ");
        }
        for (String id : ids) {
            this.flowStepErrorRefDAO.remove(this.flowStepErrorRefDAO.get((Serializable)((Object)id)));
        }
    }

    @Override
    public void addParameterName(String flowRefId, String parameterName, boolean global) throws FlowRefException {
        if (parameterName == null) {
            throw new FlowRefException("You must specify a flow step parameter name referential");
        }
        this.addParameterName(flowRefId, -1, parameterName, global);
    }

    @Override
    public void addParameterName(String flowStepRefId, int index, String parameterName, boolean global) throws FlowRefException {
        this.verificationParameter(flowStepRefId, parameterName);
        FlowStepRef flowstepRef = (FlowStepRef)this.flowStepRefDAO.get((Serializable)((Object)flowStepRefId));
        if (index > -1) {
            StepParameter parameter = new StepParameter(parameterName, global);
            flowstepRef.addParameterName(index, parameter);
        } else {
            StepParameter parameter = new StepParameter(parameterName, global);
            flowstepRef.addParameterName(parameter);
        }
        this.flowStepRefDAO.save((Object)flowstepRef);
    }

    @Override
    public void updateParameterName(String flowStepRefId, int index, String parameterName, boolean global) throws FlowRefException {
        this.verificationParameter(flowStepRefId, parameterName);
        FlowStepRef flowStepRef = (FlowStepRef)this.flowStepRefDAO.get((Serializable)((Object)flowStepRefId));
        StepParameter parameter = new StepParameter(parameterName, global);
        flowStepRef.updateParameterName(index, parameter);
        this.flowStepRefDAO.save((Object)flowStepRef);
    }

    @Override
    public void removeParameterName(String flowStepId, int index) throws FlowRefException {
        if (flowStepId == null) {
            throw new FlowRefException("You must specify a flow step referential ");
        }
        FlowStepRef result = (FlowStepRef)this.flowStepRefDAO.get((Serializable)((Object)flowStepId));
        result.removeParameterName(index);
        this.flowStepRefDAO.save((Object)result);
    }

    @Override
    public void removeParameterNames(String flowStepId, int[] indexes) throws FlowRefException {
        if (flowStepId == null) {
            throw new FlowRefException("You must specify a flow step referential ");
        }
        FlowStepRef result = (FlowStepRef)this.flowStepRefDAO.get((Serializable)((Object)flowStepId));
        this.removeParameterName(result, indexes);
        this.flowStepRefDAO.save((Object)result);
    }

    private void removeParameterName(FlowStepRef flowStepRef, int[] indexes) {
        if (indexes.length > 0) {
            flowStepRef.removeParameterName(indexes[0]);
            int[] decrementedIndexes = new int[indexes.length - 1];
            for (int i = 1; i < indexes.length; ++i) {
                int treatedInt = indexes[i];
                decrementedIndexes[i - 1] = treatedInt > indexes[0] ? treatedInt - 1 : treatedInt;
            }
            this.removeParameterName(flowStepRef, decrementedIndexes);
        }
    }

    private void verificationdate(FlowStepRef flowStepRef, FlowStepRef flowStepRefTmp) {
        FlowStepRef existingEndStep;
        FlowStepRef existingStartStep;
        if (flowStepRef.isFlowStartStep() && !flowStepRefTmp.isFlowStartStep() && (existingStartStep = this.flowStepRefDAO.loadStartStepByFlowType(flowStepRef.getFlowref().getType())) != null && existingStartStep.getId() != flowStepRef.getId()) {
            throw new FlowRefManagerRuntimeException("Already existing start flow step for this type of flow");
        }
        if (flowStepRef.isFlowEndStep() && !flowStepRefTmp.isFlowEndStep() && (existingEndStep = this.flowStepRefDAO.loadEndStepByFlowType(flowStepRef.getFlowref().getType())) != null && existingEndStep.getId() != flowStepRef.getId()) {
            throw new FlowRefManagerRuntimeException("Already existing end flow step for this type of flow");
        }
    }

    private void verification(FlowStepRef flowStepRef, FlowStepRef flowStepRefTmp) throws FlowRefException {
        if (flowStepRef.getName() == null) {
            throw new FlowRefManagerRuntimeException("You must specify a name ");
        }
        if (flowStepRef.getFlowref() == null) {
            throw new FlowRefManagerRuntimeException("You must specify a flow referential ");
        }
        FlowRef flowRef = this.flowRefManager.loadFlowRef(flowStepRef.getFlowref().getId());
        if (flowRef == null) {
            throw new FlowRefException("you must specify a valid flow referential");
        }
        int type = flowStepRef.getFlowref().getType();
        String interfaceName = flowStepRef.getInterfaceName();
        String serviceName = flowStepRef.getServiceName();
        if (flowStepRefTmp.getId() != null) {
            FlowStepRef tmp;
            FlowStepRef flowStepTmp;
            if (!(flowStepRef.getServiceName().equals(flowStepRefTmp.getServiceName()) && flowStepRef.getInterfaceName().equals(flowStepRefTmp.getInterfaceName()) || (flowStepTmp = this.flowStepRefDAO.loadByFlowTypeIntNameServName(type, interfaceName, serviceName)) == null || flowStepTmp.getId().equals(flowStepRef.getId()))) {
                throw new FlowRefManagerRuntimeException("a flow step with that service and interface already exist in database.");
            }
            if (!flowStepRef.getName().equals(flowStepRefTmp.getName()) && (tmp = this.flowStepRefDAO.loadStartStepByName(flowStepRef.getName())) != null) {
                throw new FlowRefManagerRuntimeException("a flow step with that name already exist in database.");
            }
        } else {
            FlowStepRef flowStepTmp = this.flowStepRefDAO.loadByFlowTypeIntNameServName(type, interfaceName, serviceName);
            if (flowStepTmp != null && !flowStepTmp.getId().equals(flowStepRef.getId())) {
                throw new FlowRefManagerRuntimeException("a flow step with that service and interface already exist in database.");
            }
            flowStepTmp = new FlowStepRef();
            flowStepTmp = this.flowStepRefDAO.loadStartStepByName(flowStepRef.getName());
            if (flowStepTmp != null) {
                throw new FlowRefManagerRuntimeException("a flow step with that name already exist in database.");
            }
        }
    }

    private void verificationErrorRef(FlowStepErrorRef stepErrorRef, FlowStepErrorRef stepErrorRefTmp) throws FlowRefException {
        if (stepErrorRefTmp != null) {
            if (stepErrorRef.getId() != null) {
                if (!stepErrorRef.getId().equals(stepErrorRefTmp.getId()) && stepErrorRef.getErrorCode() == stepErrorRefTmp.getErrorCode()) {
                    throw new FlowRefException("An error referential already exist with that error code in database " + stepErrorRef.getErrorCode());
                }
            } else {
                throw new FlowRefException("An error referential already exist with that error code in database " + stepErrorRef.getErrorCode());
            }
        }
        if (stepErrorRef.getFlowstepref() == null || stepErrorRef.getFlowstepref().getId() == null) {
            throw new FlowRefException("You must specify a flow step referential ");
        }
        if (stepErrorRef.getMessage() == null) {
            throw new FlowRefException("You must specify a flow step error message referential ");
        }
    }

    private void verificationParameter(String flowStepRefId, String parameterName) throws FlowRefException {
        if (flowStepRefId == null) {
            throw new FlowRefException("You must specify a flow step referential ");
        }
        if (parameterName == null) {
            throw new FlowRefException("You must specify a flow step parameter name referential ");
        }
    }
}

