package com.ebmwebsourcing.petalsview.service.dataexporter.adapter.flow;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowStepDTO;
import com.ebmwebsourcing.petalsview.service.flow.FlowException;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;

@Service("flowAdapter")
public class FlowAdapter 
{
	
	@Resource(name = "flowStepManager")
	private FlowStepManager flowStepManager;
	
	private FlowStepAdapter flowStepAdapter = new FlowStepAdapter ();
	
	public void populateDTO (final FlowDTO flowDTO, final Flow flow ) throws FlowException{
		
		flowDTO.setId(flow.getId());
		flowDTO.setIdpetals(flow.getIdpetals());
		flowDTO.setType(flow.getType());

		populateFlowStepList(flowDTO, flow);
	}
	
	private void populateFlowStepList (final FlowDTO flowDTO, final Flow flow) throws FlowException{
		List<FlowStepDTO> flowStepDTOList = new ArrayList <FlowStepDTO> ();
	
		List<FlowStep> flowStepList = flowStepManager.loadSteps(flow.getIdpetals(), flow.getType());
		
		for(FlowStep flowStep : flowStepList){
			FlowStepDTO flowStepDTO = new FlowStepDTO ();
			flowStepAdapter.populateDTO(flowStepDTO, flowStep);
			flowStepDTOList.add(flowStepDTO);
			
		}
		
		flowDTO.setFlowSteps(flowStepDTOList);
		
	}
}
