package com.ebmwebsourcing.petalsview.service.dataexporter.adapter.flow;

import java.util.Date;
import java.util.ArrayList;
import java.util.List;


import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowStepDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowStepParameterDTO;


public class FlowStepAdapter 
{	
	public void populateDTO(final FlowStepDTO flowStepDTO, FlowStep flowStep)
	{
		flowStepDTO.setId(flowStep.getId());
		flowStepDTO.setInterfaceName(flowStep.getInterfaceName());
		flowStepDTO.setServiceName(flowStep.getServiceName());
		flowStepDTO.setEndpointName(flowStep.getEndpointName());
		flowStepDTO.setMeUUID(flowStep.getMeUUID());
		flowStepDTO.setIdpetals(flowStep.getFlow().getIdpetals());
		flowStepDTO.setStartDate(new Date (flowStep.getStartDate()));
		flowStepDTO.setEndDate(new Date (flowStep.getEndDate()));
		flowStepDTO.setErrorCode(flowStep.getErrorCode());
		flowStepDTO.setStatus(flowStep.getStatus());
		
		populateParameters(flowStepDTO, flowStep);
	}
	
	private void populateParameters (final FlowStepDTO flowStepDTO, FlowStep flowStep) {
		final List <FlowStepParameterDTO> parameters = new ArrayList <FlowStepParameterDTO> ();
		
		for(int i =0; i<flowStep.getParameters().size(); i++){
			final FlowStepParameterDTO parameter = new FlowStepParameterDTO();
			parameter.setIdx(i);
			parameter.setName(flowStep.getParameters().get(i));
			parameters.add(parameter);
		}
		flowStepDTO.setParameters(parameters);
		
	}
}
