package com.ebmwebsourcing.petalsview.service.dataexporter.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;

import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import org.springframework.stereotype.Service;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.service.dataexporter.adapter.flow.FlowAdapter;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowStepDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.flow.FlowStepParameterDTO;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.thoughtworks.xstream.XStream;


@Service("flowExporter")
public class ExporterFlowImpl implements ExporterFlow 
{
	@Resource(name  = "flowAdapter")
	private FlowAdapter flowAdapter;
	
	@Resource(name = "flowStepManager")
	private FlowStepManager flowStepManager;
	
	public void exportFlowsByJaxb (List <Flow> flows, String urlAndName) throws Exception 
	{
		final FileOutputStream file = new FileOutputStream(new File((urlAndName)));
	        final PrintStream printer = new PrintStream(file);
	        
	        Marshaller marshaller = prepareMarshaller();

	        printer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
	        
	        for (Flow flow  : flows)
	        {
	            FlowDTO flowDTO = new FlowDTO();
	            
	            flowAdapter.populateDTO(flowDTO, flow);
	            marshaller.marshal(flowDTO, file);
	        }  
	}
	
	public void exportFlowsByXtream (List <Flow> flows, String urlAndName) throws Exception 
	{
		final FileOutputStream file = new FileOutputStream(new File((urlAndName)));
	        final PrintStream printer = new PrintStream(file);
	        
	        for(Flow f : flows){
				List<FlowStep> flowSteps = flowStepManager.loadSteps(f.getIdpetals(),f.getType());
				f.setListFlowStep(flowSteps);
			}
	             
	       printer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
	        
	        XStream xstream = new XStream();
			xstream.processAnnotations(Flow.class);

			xstream.toXML(flows, file);
	}
	
	private Marshaller prepareMarshaller() throws Exception {
		final JAXBContext jaxbContext = JAXBContext.newInstance(
				FlowDTO.class, FlowStepDTO.class,
				FlowStepParameterDTO.class);

		final Marshaller marshaller = jaxbContext.createMarshaller();
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
		marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);

		return marshaller;
	}

}
