package com.ebmwebsourcing.petalsview.service.dataloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;

import com.ebmwebsourcing.webcommons.util.JAXBUtil;
import com.petalsview.dataset.Dataset;



public class ViewDatasetHandler {

    private static ViewDatasetHandler instance;
    
    /**
     * The JAXB unique unmarshaller.
     */
    private static Unmarshaller unmarshaller;

    @SuppressWarnings("unused")
	private static Marshaller marshaller;

    

    @SuppressWarnings("unchecked")
    private static final List<Class> defaultObjectFactories = new ArrayList<Class>(Arrays
            .asList(new Class[] { com.petalsview.dataset.ObjectFactory.class }));
    
    
    private ViewDatasetHandler () throws DataLoaderException {
        try {
            JAXBContext context = JAXBUtil.createJAXBContext(defaultObjectFactories);
            unmarshaller = context.createUnmarshaller();
            marshaller = context.createMarshaller();
        } catch (final JAXBException e) {
            throw new DataLoaderException(e);
        }
    }
    
    /**
     * Build the Java bindings from the Petals View dataset in XML form. The
     * validation against the dataset schema is processed during the
     * transformation.
     * 
     * @param datasetStream
     *            The Petals View dataset in XML form
     * @return The root object of the dataset
     * @throws DataLoaderException
     *             The exception raised during the unmarshaller creation or the
     *             exception raised during the build of the java bindings.
     */
    public Dataset convertStreamSource2ViewDataset(final Source datasetStream)
            throws DataLoaderException {

        try {
            // TODO : Check if it is a Thread safe method
            final JAXBElement<Dataset> wsdlBinding = unmarshaller.unmarshal(datasetStream,
                    Dataset.class);

            return wsdlBinding.getValue();

        } catch (final JAXBException e) {
            throw new DataLoaderException(
                    "Failed to build Java bindings from dataset XML document", e);
        }
    }

    public static ViewDatasetHandler getInstance() throws DataLoaderException {
        if (instance == null) {
            instance = new ViewDatasetHandler();
        }
        return instance;
    }
}
