package com.ebmwebsourcing.petalsview.service.flow;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowStepDAO;
import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;

@Service("flowStepManager")
public class FlowStepManagerImpl implements FlowStepManager {
	
	@Resource(name = "flowDAO")
	private FlowDAO flowDAO;

	@Resource(name = "flowStepDAO")
	private FlowStepDAO flowStepDAO;

	public FlowStep loadFlowStep(final String flowStepId) throws FlowException {
		if (flowStepId == null) {
			throw new FlowException("no flow step whith this id in database ! ");
		}

		final FlowStep result = (FlowStep) flowStepDAO.get(flowStepId);
		return result;
	}

	public FlowStep loadFlowStep(final String flowId, final String meUUID,
			final String interfaceName, final String serviceName,
			final String endpointName) {
		
		final FlowStep result = flowStepDAO.loadByMeUUID(meUUID);
		return result;
	}

	public List<FlowStep> loadSteps(final String id, final int type)throws FlowException {
		List<FlowStep> result = new ArrayList<FlowStep>();
		if (id != null) {
			result = flowStepDAO.loadByFlowId(id);
		} else {
			List<Flow> flows = flowDAO.loadByType(type);
			if (flows != null && !flows.isEmpty()) {

				result = flowStepDAO.loadByFlowId(flows.get(0).getIdpetals());
			} else {
				result = null;
			}
		}

		return result;
	}

	public List<FlowStep> loadRunningSteps(final String flowId)throws FlowException {
		if(flowId == null){
			throw new FlowException("no flow step whith this id in database ! ");
		}
		final List<FlowStep> result = flowStepDAO.loadRunningByFlowId(flowId);
		return result;
	}

	public List<FlowStep> loadFlowSteps(final String flowId,
			final String interfaceName, final String serviceName) {
		final List<FlowStep> result = flowStepDAO.loadByFlowIdAndMeProps(
				flowId, interfaceName, serviceName);
		return result;
	}

	public List<String> loadUnknownParameters(final String interfaceName,
			final String serviceName) {
		final List<FlowStep> result = flowStepDAO.loadByFlowIdAndMeProps(null,
				interfaceName, serviceName);
		List<String> unknownParameters = new ArrayList<String>();
		if (result != null && !result.isEmpty()) {
			for (int i = 0; i < result.size(); i++) {
				if (result.get(i).getParameters() != null
						&& !result.get(i).getParameters().isEmpty()) {
					unknownParameters = result.get(i).getParameters();
					break;
				} else if (result.get(i).getParameters() == null
						&& i == result.size()) {
					unknownParameters = null;
				}
			}
		}
		return unknownParameters;
	}

	public void removeStep(final String flowId, final String meUUID,
			final String interfaceName, final String serviceName,
			final String endpointName) throws FlowException {

		final FlowStep flowStep = flowStepDAO.loadByMeUUID(meUUID);

		if (flowStep == null) {
			throw new FlowException(
					"no flow step whith this petals id in database ! ");
		}
		flowStepDAO.remove(flowStep);
	}

	public void addStep(final Flow flow, final FlowStep flowStep) {
		flowStep.setFlow(flow);
		flowStepDAO.save(flowStep);
	}

	public void updateStep(final FlowStep flowStep) {
		flowStepDAO.save(flowStep);
	}
}
