/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowRefManager.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.service.flowref;

import java.util.Date;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowParamsDetails;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowWithParams;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.GlobalFlowParam;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;


@Transactional
public interface FlowRefManager {

    @Transactional(readOnly = true)
    FlowRef getFlowRef(final int type);
    
    @Transactional(readOnly = true)
    FlowRef loadFlowRef (final String id) throws FlowRefException;
   
    @Transactional(readOnly = true)
    List<String> loadAllServiceName();

    @Transactional(readOnly = true)
    List<String> loadAllInterfaceName();

    @Transactional(readOnly = true)
    List<String> loadAllEndpointName();

    @Transactional(readOnly = true)
    List<FlowRef> loadAll();

    String createFlowRef(final int type, final String name) throws FlowRefException;

    void update(final FlowRef flowRef) throws FlowRefException;

    void removeFlowRef(final int[] flowRefTypes) throws FlowRefException;
    
    void removeFlowRef(int type) throws FlowRefException;

    @Transactional(readOnly = true)
    List<GlobalFlowParam> getGlobalFlowParameters(final short flowType);

    @Transactional(readOnly = true)
    List<FlowWithParams> getFlowsWithParameters(final List<GlobalFlowParam> globalParams,
            final short type, final Date after, final Date before);

    @Transactional(readOnly = true)
    List<FlowParamsDetails> getDetailFlowParameter(final short flowType, final String flowId) throws FlowRefException;
}
