package com.ebmwebsourcing.petalsview.service.flowref;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;

@Transactional
public interface FlowStepRefManager {

	//Flow Step Referential
	@Transactional(readOnly = true)
	List<FlowStepRef> loadSteps(final int type);

	@Transactional(readOnly = true)
	FlowStepRef loadStepRef(final int type, final String interfaceName,
			final String serviceName) throws FlowRefException;

	@Transactional(readOnly = true)
	FlowStepRef loadStepRef(final String id) throws FlowRefException;

	String saveOrUpdateStepRef(final FlowStepRef flowStepRef) throws FlowRefException;
	
	void removeStepRefs(final String[] ids) throws FlowRefException;

	

	//Flow Error Referential 
	@Transactional(readOnly = true)
	FlowStepErrorRef loadStepErrorRef(final String id) throws FlowRefException;

	@Transactional(readOnly = true)
	List<FlowStepErrorRef> loadStepRefErrors(final String stepRefId) throws FlowRefException;

	String saveOrUpdateErrorRef(final FlowStepErrorRef stepErrorRef) throws FlowRefException;
	
	void removeErrorRefs(final String[] ids) throws FlowRefException;

	
	//Flow Parameter Referential
	void addParameterName(final String flowRefId, final String parameterName,
			final boolean global) throws FlowRefException;

	void addParameterName(final String flowStepRefId, final int index,
			final String parameterName, final boolean global) throws FlowRefException;

	void updateParameterName(final String flowStepRefId, final int index,
			final String parameterName, final boolean global) throws FlowRefException;
	
	void removeParameterName(final String flowStepId, final int index) throws FlowRefException;

	void removeParameterNames(final String flowStepId, final int[] indexes) throws FlowRefException;

	

	

	
	
}
