/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowStepDAO.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.persistence.dao.flow;

import java.util.List;

import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericORMDAO;

public interface FlowStepDAO extends GenericORMDAO<FlowStep, String> {
    List<FlowStep> loadByFlowId(final String id);

    FlowStep loadByMeUUID(final String meUUID);

    List<FlowStep> loadByFlowIdAndMeProps(final String flowId, final String interfaceName,
            final String serviceName);

    List<FlowStep> loadRunningByFlowId(final String id);

    public List<FlowStep> getAllOrderByServiceName();
}
