/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowStepDAOImpl.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.persistence.dao.flow;

import java.util.List;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericHibernateDAOImpl;
import com.trg.search.Search;

@Repository("flowStepDAO")
public class FlowStepDAOImpl extends GenericHibernateDAOImpl<FlowStep, String> implements FlowStepDAO {

    @Autowired
    public FlowStepDAOImpl(@Qualifier("sessionFactory") SessionFactory factory) {
        super(factory);
    }

    public List<FlowStep> loadByFlowId(final String id) {
        return this.search(new Search().addFilterEqual("flow.idpetals", id).addSortAsc("endDate"));
    }

    public FlowStep loadByMeUUID(final String meUUID) {
        return this.searchUnique(new Search().addFilterEqual("meUUID", meUUID));
    }

    public List<FlowStep> loadByFlowIdAndMeProps(final String flowId, final String interfaceName,
            final String serviceName) {
    	if(interfaceName == null){
    		return null;
    	}
    	if(serviceName == null){
    		return null;
    	}
    	
        return this.search(new Search().addFilterEqual("flow.idpetals", flowId).addFilterEqual(
                "interfaceName", interfaceName).addFilterEqual("serviceName", serviceName));
    }

    public List<FlowStep> loadRunningByFlowId(final String id) {
        return this.search(new Search().addFilterEqual("flow.idpetals", id).addFilterEqual(
                "status", 2).addSortAsc("startDate"));
    }

    public List<FlowStep> getAllOrderByServiceName() {
        Search search = new Search();
        search.setDistinct(true);
        search.addSortAsc("serviceName");
        return this.search(search);
    }
}
