/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowStepRefDAOImpl.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.persistence.dao.flowref;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.dbcp.BasicDataSource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericHibernateDAOImpl;
import com.trg.search.Search;

@Repository("flowStepRefDAO")
public class FlowStepRefDAOImpl extends
		GenericHibernateDAOImpl<FlowStepRef, String> implements FlowStepRefDAO {

	@Autowired
	public FlowStepRefDAOImpl(
			@Qualifier("sessionFactory") SessionFactory factory) {
		super(factory);
	}

	@Resource
	private BasicDataSource dataSource;

	public List<FlowStepRef> loadByFlowType(final int type) {
		return this.search(new Search().addFilterEqual("flowref.type", type));
	}

	public FlowStepRef loadStartStepByFlowType(final int type) {
		return this.searchUnique(new Search().addFilterEqual("flowref.type",
				type).addFilterEqual("flowStartStep", true));
	}

	public FlowStepRef loadEndStepByFlowType(final int type) {
		return this.searchUnique(new Search().addFilterEqual("flowref.type",
				type).addFilterEqual("flowEndStep", true));
	}

	public FlowStepRef loadByFlowTypeIntNameServName(final int type,
			final String interfaceName, final String serviceName) {
		return this.searchUnique(new Search().addFilterEqual("flowref.type",
				type).addFilterEqual("interfaceName", interfaceName)
				.addFilterEqual("serviceName", serviceName));
	}

	public FlowStepRef loadStartStepByName(final String name) {
		return this.searchUnique(new Search().addFilterEqual("name", name));
	}

	@SuppressWarnings("unchecked")
	public List<GlobalFlowParam> getGlobalFlowParameters(final short flowType) {
		String booleanValue = getBooleanValue();
		final Session session = this.getSession();
		final Query query = session.createSQLQuery(
				"select " + "p.name, s.serviceName, s.interfaceName, p.idx "
						+ "from FLOWREF f " + "join FLOWSTEPREF s "
						+ "on f.id = s.flowref_id "
						+ "join FLOWREF_PARAMNAMES p "
						+ "on p.FLOWSTEPREF_id = s.id " + "where f.type=:type "
						+ "and p.global = " + booleanValue
						+ " order by s.id, p.idx ").setShort("type", flowType)
				.setResultTransformer(
						Transformers.aliasToBean(GlobalFlowParam.class));

		final List<GlobalFlowParam> ret = query.list();

		return ret;

	}

	public List<FlowWithParams> getFlowsWithParameters(
			final List<GlobalFlowParam> globalParams, final short type,
			final Date after, final Date before) {
		final Session session = this.getSession();
		final String requete = createQuery(globalParams, type, after, before);

		final List<FlowWithParams> ret = new ArrayList<FlowWithParams>();

		try {
			session.doWork(new Work() {
				public void execute(Connection connection) throws SQLException {
					Statement stt = connection.createStatement();
					ResultSet rs = stt.executeQuery(requete);
					FlowWithParams flowWithParams;
					List<String> listElements = null;

					while (rs.next()) {
						flowWithParams = new FlowWithParams();

						flowWithParams.setId(rs.getLong(1));
						flowWithParams.setIdpetals(rs.getString(2));

						if (rs.getLong(3) != 0) {
							Long longDate = rs.getLong(3);
							Date startDate = new Date(longDate);
							flowWithParams.setStartDate(startDate);
						}

						if (rs.getLong(4) != 0) {
							Long longDate = rs.getLong(4);
							Date endDate = new Date(longDate);
							flowWithParams.setEndDate(endDate);
						}

						flowWithParams.setStatus(rs.getInt(5));

						listElements = new ArrayList<String>();
						for (int i = 0; i < globalParams.size(); i++) {

							final String element = rs.getString(i + 6);
							listElements.add(element);
						}
						flowWithParams.setElement(listElements);

						ret.add(flowWithParams);
					}
				}
			});

		} catch (final Throwable t) {
			t.printStackTrace();
		}
		if (ret != null) {
			for (final FlowWithParams flow : ret) {
				if (flow.getEndDate() == null) {
					flow.setStatus(Integer.valueOf(-1));
				}
			}
		}

		return ret;
	}

	private String createQuery(final List<GlobalFlowParam> globalParams,
			final short type, final Date after, final Date before) {
		String booleanValue = getBooleanValue();
		// Construction de la requete :
		final StringBuffer queryBuf = new StringBuffer();
		queryBuf.append("select");
		queryBuf
				.append(" f.id ,f.idpetals, ffs.startDate, lfs.endDate, lfs.status ");
		for (int i = 0; i < globalParams.size(); i++) {
			queryBuf.append(", p" + i + ".element ");
		}
		queryBuf.append(" from FLOW f ");
		String currentService = null;
		String currentInterface = null;
		int srvIdx = -1;
		for (int i = 0; i < globalParams.size(); i++) {
			final GlobalFlowParam curParam = globalParams.get(i);
			if (!curParam.getInterfaceName().equals(currentInterface)
					|| !curParam.getServiceName().equals(currentService)) {
				// --- open a left join for the service
				srvIdx++;
				currentInterface = curParam.getInterfaceName();
				currentService = curParam.getServiceName();
				queryBuf.append(" left join FLOWSTEP s" + srvIdx);
				queryBuf.append(" on s" + srvIdx
						+ ".flow_id = f.idpetals and s" + srvIdx
						+ ".serviceName = '" + curParam.getServiceName() + "' "
						+ "and s" + srvIdx + ".interfaceName = '"
						+ curParam.getInterfaceName() + "'");
			}
			// --- left join the parameter
			queryBuf.append(" left join FLOW_PARAMS p" + i);
			queryBuf.append(" on p" + i + ".FLOWSTEP_id = s" + srvIdx
					+ ".id and p" + i + ".idx = " + curParam.getIdx());
		}
		queryBuf.append(" left join FLOWREF fr ");
		queryBuf.append(" on fr.type = " + type);
		queryBuf.append(" left join FLOWSTEPREF ffsr ");
		queryBuf.append("on fr.id = ffsr.flowref_id and ffsr.flowstartstep = "
				+ booleanValue);
		queryBuf.append(" left join FLOWSTEP ffs ");
		queryBuf
				.append("on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName "
						+ " and ffs.interfaceName = ffsr.interfaceName ");
		queryBuf.append("left join FLOWSTEPREF lfsr ");
		queryBuf.append("on fr.id = lfsr.flowref_id and lfsr.flowendstep = "
				+ booleanValue);
		queryBuf.append(" left join FLOWSTEP lfs ");
		queryBuf
				.append("on lfs.flow_id = f.idpetals and lfs.serviceName = lfsr.serviceName "
						+ " and lfs.interfaceName = lfsr.interfaceName ");
		queryBuf.append(" where f.type = " + type);

		if (before != null || after != null) {
			queryBuf.append(" and ffs.startdate is not null ");
		}

		if (before != null) {
			queryBuf.append(" and ffs.startdate < '" + before.getTime() + "'");
		}
		if (after != null) {
			queryBuf.append(" and ffs.startdate > '" + after.getTime() + "' ");
		}
		queryBuf.append(" order by ffs.startdate, lfs.status, f.id");

		final String requete = queryBuf.toString();
		return requete;
	}

	@SuppressWarnings("unchecked")
	public List<FlowParamsDetails> getDetailFlowParameter(final short flowType,
			final String flowId) {
		String booleanValue = getBooleanValue();
		final Session session = this.getSession();

		final Query query = session
				.createSQLQuery(
						"select pr.name, pr.idx, p.element "
								+ " from FLOWREF fr "
								+ " join FLOWSTEPREF sr "
								+ " on fr.id = sr.flowref_id "
								+ " join FLOWREF_PARAMNAMES pr "
								+ " on pr.FLOWSTEPREF_id = sr.id "
								+ " left join FLOWSTEP s "
								+ "  on s.flow_id = '"
								+ flowId
								+ "' and s.serviceName = sr.serviceName and s.interfaceName = sr.interfaceName "
								+ " left join FLOW_PARAMS p "
								+ " on p.FLOWSTEP_id = s.id and p.idx = pr.idx "
								+ " where " + " fr.type=" + flowType
								+ " and pr.global = " + booleanValue
								+ " order by sr.id, pr.idx")
				.setResultTransformer(
						Transformers.aliasToBean(FlowParamsDetails.class));

		final List<FlowParamsDetails> ret = query.list();

		return ret;

	}

	private String getBooleanValue() {
		String value = null;
		String prop = dataSource.getDriverClassName();
		if (prop.equals("org.postgresql.Driver")) {
			value = "true";
			return value;
		} else {
			return value = "1";
		}
	}

}
