/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowStep.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.persistence.model.flow;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.IndexColumn;

import com.ebmwebsourcing.webcommons.persistence.bo.StringIdBaseObject;

/**
 * This class represents a functional flow step instance in Petals.
 * 
 * @author Pierre SMEYERS, ofabre
 */
@Entity(name = "com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep")
@Table(name = "FLOWSTEP")
public class FlowStep extends StringIdBaseObject {

    private static final long serialVersionUID = 5234804409942965567L;

    // ========================================================================
    // === Attributes
    // ========================================================================
    private String interfaceName;

    private String serviceName;

    private String endpointName;

    private String meUUID;

    private Long startDate;

    private Long endDate;

    private int status;

    private int errorCode;

    private List<String> parameters;

    private Flow flow;

    // ========================================================================
    // === Constructors
    // ========================================================================
    public FlowStep() {
    }

    // ========================================================================
    // === Attributes Getters & Setters
    // ========================================================================

    public Long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(final Long startDate) {
        this.startDate = startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(final Long endDate) {
        this.endDate = endDate;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(final int status) {
        this.status = status;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(final String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(final String serviceName) {
        this.serviceName = serviceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(final String endpointName) {
        this.endpointName = endpointName;
    }

    @Column(unique = true, nullable = false)
    @Index(name = "meUUIDindex")
    public String getMeUUID() {
        return this.meUUID;
    }

    public void setMeUUID(final String meUUID) {
        this.meUUID = meUUID;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "flow_id", nullable = false, updatable = false, referencedColumnName = "idpetals")
    @ForeignKey(name = "FK_FLOW_id_FLOWSTEP_flow")
    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(final Flow flow) {
        this.flow = flow;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(final int errorCode) {
        this.errorCode = errorCode;
    }

    @CollectionOfElements(fetch = FetchType.LAZY)
    @JoinTable(name = "FLOW_PARAMS")
    @IndexColumn(name = "idx")
    @ForeignKey(name = "FK_FLOWPARAMS_id_FLOW")
    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(final List<String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof FlowStep))
            return false;
        FlowStep castOther = (FlowStep) other;
        return new EqualsBuilder().append(interfaceName, castOther.interfaceName).append(
                serviceName, castOther.serviceName).append(endpointName, castOther.endpointName)
                .append(meUUID, castOther.meUUID).append(startDate, castOther.startDate).append(
                        endDate, castOther.endDate).append(status, castOther.status).append(
                        errorCode, castOther.errorCode).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(interfaceName).append(serviceName).append(endpointName)
                .append(meUUID).append(startDate).append(endDate).append(status).append(errorCode)
                .toHashCode();
    }

}
