/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * StepParameter.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.petalsview.persistence.model.flowref;

import javax.persistence.Embeddable;

/**
 * @author ofabre
 *
 */
@Embeddable
public class StepParameter {
	
	private String name;
	
	private boolean global;

	public String getName() {
		return name;
	}

	public StepParameter() {
		super();
	}

	public StepParameter(String name, boolean global) {
		super();
		this.name = name;
		this.global = global;
	}

	public void setName(String name) {
		this.name = name;
	}

	public boolean isGlobal() {
		return global;
	}

	public void setGlobal(boolean global) {
		this.global = global;
	}

}
