/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.persistence.dao.flow;

import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowDAO;
import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericHibernateDAOImpl;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.dbcp.BasicDataSource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="flowDAO")
public class FlowDAOImpl
extends GenericHibernateDAOImpl<Flow, Long>
implements FlowDAO {
    @Resource
    private BasicDataSource dataSource;

    @Autowired
    public FlowDAOImpl(@Qualifier(value="sessionFactory") SessionFactory factory) {
        super(factory);
    }

    @Override
    public Flow loadByPetalsId(String petalsId) {
        Search search = new Search();
        Flow flow = (Flow)this.searchUnique((IMutableSearch)search.addFilterEqual("idpetals", (Object)petalsId));
        return flow;
    }

    @Override
    public List<Flow> loadAllStarted() {
        return this.search((IMutableSearch)new Search().addFilterNotNull("startDate").addSortDesc("startDate"));
    }

    @Override
    public List<Flow> loadByType(int type) {
        return this.search((IMutableSearch)new Search().addFilterEqual("type", (Object)type));
    }

    @Override
    public List<Flow> loadUnknowsFlow(List<Integer> types) {
        Search search = new Search();
        search.addFilterNotIn("type", types);
        return this.search((IMutableSearch)search);
    }

    @Override
    public List<Flow> loadAllStartedByType(int type) {
        return this.search((IMutableSearch)new Search().addFilterEqual("type", (Object)type).addFilterNotNull("startDate").addSortDesc("startDate"));
    }

    @Override
    public List<Flow> loadAll() {
        String booleanValue = this.getBooleanValue();
        Session session = this.getSession();
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("select");
        queryBuf.append(" f.id,f.idpetals, ffs.startDate, lfs.endDate, lfs.status, f.type ");
        queryBuf.append(" from FLOW f ");
        queryBuf.append(" left join FLOWREF fr ");
        queryBuf.append(" on fr.type = f.type");
        queryBuf.append(" left join FLOWSTEPREF ffsr ");
        queryBuf.append("on fr.id = ffsr.flowref_id and ffsr.flowstartstep = " + booleanValue);
        queryBuf.append(" left join FLOWSTEP ffs ");
        queryBuf.append("on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName and ffs.interfaceName = ffsr.interfaceName ");
        queryBuf.append("left join FLOWSTEPREF lfsr ");
        queryBuf.append("on fr.id = lfsr.flowref_id and lfsr.flowendstep = " + booleanValue);
        queryBuf.append(" left join FLOWSTEP lfs ");
        queryBuf.append("on lfs.flow_id = f.idpetals and lfs.serviceName = lfsr.serviceName and lfs.interfaceName = lfsr.interfaceName order by ffs.startDate, lfs.status, f.id");
        String requete = queryBuf.toString();
        Query q = session.createSQLQuery(requete).setResultTransformer(Transformers.aliasToBean(Flow.class));
        List<Flow> result = new ArrayList<Flow>();
        if (q != null && (result = q.list()) != null) {
            for (Flow flow : result) {
                if (flow.getEndDate() != null) continue;
                flow.setStatus(-1);
            }
        }
        return result;
    }

    public List<Flow> loadAll2() {
        Search search = new Search();
        search.addSortDesc("startDate");
        return this.search((IMutableSearch)search);
    }

    @Override
    public List<Flow> loadAllStartedWithDateFilter(Date startDate, Date endDate) {
        String booleanValue = this.getBooleanValue();
        Session session = this.getSession();
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("select");
        queryBuf.append(" f.id,f.idpetals, ffs.startDate, lfs.endDate,f.type , lfs.status");
        queryBuf.append(" from FLOW f ");
        queryBuf.append(" left join FLOWREF fr ");
        queryBuf.append(" on fr.type = f.type");
        queryBuf.append(" left join FLOWSTEPREF ffsr ");
        queryBuf.append("on fr.id = ffsr.flowref_id and ffsr.flowstartstep = " + booleanValue);
        queryBuf.append(" left join FLOWSTEP ffs ");
        queryBuf.append("on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName and ffs.interfaceName = ffsr.interfaceName ");
        queryBuf.append("left join FLOWSTEPREF lfsr ");
        queryBuf.append("on fr.id = lfsr.flowref_id and lfsr.flowendstep = " + booleanValue);
        queryBuf.append(" left join FLOWSTEP lfs ");
        queryBuf.append("on lfs.flow_id = f.idpetals and lfs.serviceName = lfsr.serviceName and lfs.interfaceName = lfsr.interfaceName ");
        queryBuf.append(" where ffs.startdate is not null ");
        if (endDate != null) {
            queryBuf.append(" and ffs.startdate < '" + endDate.getTime() + "'");
        }
        if (startDate != null) {
            queryBuf.append(" and ffs.startdate > '" + startDate.getTime() + "' order by ffs.startdate, lfs.status, f.id");
        }
        List<Flow> result = new ArrayList<Flow>();
        String requete = queryBuf.toString();
        Query q = session.createSQLQuery(requete).setResultTransformer(Transformers.aliasToBean(Flow.class));
        if (q != null && (result = q.list()) != null) {
            for (Flow flow : result) {
                if (flow.getEndDate() != null && flow.getEndDate() != 0L) continue;
                flow.setStatus(-1);
            }
        }
        return result;
    }

    public List<Flow> loadAllStartedWithDateFilter2(Date startDate, Date endDate) {
        Search search = new Search();
        search.addFilterNotNull("startDate");
        search.addSortDesc("startDate");
        if (startDate != null) {
            long longAfter = startDate.getTime();
            search.addFilterGreaterOrEqual("startDate", (Object)longAfter);
        }
        if (endDate != null) {
            long longBefore = endDate.getTime();
            search.addFilterLessOrEqual("startDate", (Object)longBefore);
        }
        return this.search((IMutableSearch)search);
    }

    private String getBooleanValue() {
        String value = null;
        String prop = this.dataSource.getDriverClassName();
        if (prop.equals("org.postgresql.Driver")) {
            value = "true";
            return value;
        }
        value = "1";
        return "1";
    }

    @Override
    public List<Flow> loadAllStartedByTypeWithDateFilter(int type, Date after, Date before) {
        long longAfter = after.getTime();
        long longBefore = before.getTime();
        Search search = new Search();
        search.addFilterNotNull("startDate");
        search.addFilterEqual("type", (Object)type);
        search.addSortDesc("startDate");
        if (after != null) {
            search.addFilterGreaterOrEqual("startDate", (Object)longAfter);
        }
        if (before != null) {
            search.addFilterLessOrEqual("startDate", (Object)longBefore);
        }
        return this.search((IMutableSearch)search);
    }
}

