/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowStepErrorRefDAOImpl.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.persistence.dao.flowref;

import java.util.List;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericHibernateDAOImpl;
import com.trg.search.Search;

@Repository("flowStepErrorRefDAO")
public class FlowStepErrorRefDAOImpl extends GenericHibernateDAOImpl<FlowStepErrorRef, String>
        implements FlowStepErrorRefDAO {

    @Autowired
    public FlowStepErrorRefDAOImpl(@Qualifier("sessionFactory") SessionFactory factory) {
        super(factory);
        // TODO Auto-generated constructor stub
    }

    public FlowStepErrorRef loadByErrorCode (final int errorCode){
    	return this.searchUnique(new Search().addFilterEqual("errorCode", errorCode));
    }
    
    public List<FlowStepErrorRef> loadByStepRefId(final String stepRefId) {
        return this.search(new Search().addFilterEqual("flowstepref.id", stepRefId).addSortAsc(
                "errorCode"));
    }
    
}
