/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowDAO.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.persistence.dao.flow;

import java.util.Date;
import java.util.List;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericORMDAO;

public interface FlowDAO extends GenericORMDAO<Flow, Long> {
    Flow loadByPetalsId(final String petalsId);

    List<Flow> loadAllStarted();

    List<Flow> loadByType(final int type);

    List<Flow> loadAllStartedByType(final int type);

    List<Flow> loadAll();

    List<Flow> loadAllStartedWithDateFilter(final Date startDate, final Date endDate);

    List<Flow> loadAllStartedByTypeWithDateFilter(final int type, final Date after,
            final Date before);

    List<Flow> loadUnknowsFlow(final List<Integer> types);
    
    List<Flow> getFlowsByDateAndType(long date, int type, int limit);

}
