/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowDAOImpl.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.persistence.dao.flow;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.dbcp.BasicDataSource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericHibernateDAOImpl;
import com.trg.search.Search;

@Repository("flowDAO")
public class FlowDAOImpl extends GenericHibernateDAOImpl<Flow, Long> implements
		FlowDAO {

	@Autowired
	public FlowDAOImpl(@Qualifier("sessionFactory") SessionFactory factory) {
		super(factory);
	}

	@Resource
	private BasicDataSource dataSource;

	public Flow loadByPetalsId(final String petalsId) {
		final Search search = new Search();
		final Flow flow = this.searchUnique(search.addFilterEqual("idpetals",
				petalsId));
		return flow;
	}

	public List<Flow> loadAllStarted() {
		return this.search(new Search().addFilterNotNull("startDate")
				.addSortDesc("startDate"));
	}

	public List<Flow> loadByType(final int type) {
		return this.search(new Search().addFilterEqual("type", type));
	}

	public List<Flow> loadUnknowsFlow(final List<Integer> types) {
		Search search = new Search();
		search.addFilterNotIn("type", types);
		return this.search(search);

	}

	public List<Flow> loadAllStartedByType(final int type) {
		return this.search(new Search().addFilterEqual("type", type)
				.addFilterNotNull("startDate").addSortDesc("startDate"));
	}

	@SuppressWarnings("unchecked")
	public List<Flow> loadAll() {
		String booleanValue = getBooleanValue();
		final Session session = this.getSession();

		final StringBuffer queryBuf = new StringBuffer();
		queryBuf.append("select");
		queryBuf
				.append(" f.id,f.idpetals, ffs.startDate, lfs.endDate, lfs.status, f.type ");
		queryBuf.append(" from FLOW f ");
		queryBuf.append(" left join FLOWREF fr ");
		queryBuf.append(" on fr.type = f.type");
		queryBuf.append(" left join FLOWSTEPREF ffsr ");
		queryBuf.append("on fr.id = ffsr.flowref_id and ffsr.flowstartstep = "
				+ booleanValue);
		queryBuf.append(" left join FLOWSTEP ffs ");
		queryBuf
				.append("on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName and ffs.interfaceName = ffsr.interfaceName ");
		queryBuf.append("left join FLOWSTEPREF lfsr ");
		queryBuf.append("on fr.id = lfsr.flowref_id and lfsr.flowendstep = "
				+ booleanValue);
		queryBuf.append(" left join FLOWSTEP lfs ");
		queryBuf
				.append("on lfs.flow_id = f.idpetals and lfs.serviceName = lfsr.serviceName "
						+ "and lfs.interfaceName = lfsr.interfaceName"
						+ " order by ffs.startDate, lfs.status, f.id");
		final String requete = queryBuf.toString();

		final Query q = session.createSQLQuery(requete).setResultTransformer(
				Transformers.aliasToBean(Flow.class));
		List<Flow> result = new ArrayList<Flow>();
		if (q != null) {
			result = q.list();

			if (result != null) {
				for (final Flow flow : result) {
					if (flow.getEndDate() == null) {
						flow.setStatus(Integer.valueOf(-1));
					}
					if (flow.getStatus() == null) {
						flow.setStatus(0);
					}
				}
			}
		}

		return result;
	}

	public List<Flow> loadAll2() {
		final Search search = new Search();
		search.addSortDesc("startDate");
		/*
		 * search.addSortDesc("status"); search.addSortDesc("id");
		 */
		return this.search(search);
	}

	@SuppressWarnings("unchecked")
	public List<Flow> loadAllStartedWithDateFilter(final Date startDate,
			final Date endDate) {
		String booleanValue = getBooleanValue();
		final Session session = this.getSession();

		final StringBuffer queryBuf = new StringBuffer();
		queryBuf.append("select");
		queryBuf
				.append(" f.id,f.idpetals, ffs.startDate, lfs.endDate,f.type , lfs.status");
		queryBuf.append(" from FLOW f ");
		queryBuf.append(" left join FLOWREF fr ");
		queryBuf.append(" on fr.type = f.type");
		queryBuf.append(" left join FLOWSTEPREF ffsr ");
		queryBuf.append("on fr.id = ffsr.flowref_id and ffsr.flowstartstep = "
				+ booleanValue);
		queryBuf.append(" left join FLOWSTEP ffs ");
		queryBuf
				.append("on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName "
						+ "and ffs.interfaceName = ffsr.interfaceName ");
		queryBuf.append("left join FLOWSTEPREF lfsr ");
		queryBuf.append("on fr.id = lfsr.flowref_id and lfsr.flowendstep = "
				+ booleanValue);
		queryBuf.append(" left join FLOWSTEP lfs ");
		queryBuf
				.append("on lfs.flow_id = f.idpetals and lfs.serviceName = lfsr.serviceName "
						+ "and lfs.interfaceName = lfsr.interfaceName ");

		queryBuf.append(" where ffs.startdate is not null ");
		if (endDate != null) {

			queryBuf.append(" and ffs.startdate < '" + endDate.getTime() + "'");
		}
		if (startDate != null) {

			queryBuf.append(" and ffs.startdate > '" + startDate.getTime()
					+ "' order by ffs.startdate, lfs.status, f.id");
		}
		List<Flow> result = new ArrayList<Flow>();
		final String requete = queryBuf.toString();

		final Query q = session.createSQLQuery(requete).setResultTransformer(
				Transformers.aliasToBean(Flow.class));

		if (q != null) {
			result = q.list();

			if (result != null) {
				for (final Flow flow : result) {
					if (flow.getEndDate() == null || flow.getEndDate() == 0) {
						flow.setStatus(Integer.valueOf(-1));
					}
				}
			}
		}

		return result;
	}

	public List<Flow> loadAllStartedWithDateFilter2(final Date startDate,
			final Date endDate) {
		final Search search = new Search();
		search.addFilterNotNull("startDate");
		search.addSortDesc("startDate");
		/*
		 * search.addSortDesc("status"); search.addSortDesc("id");
		 */
		if (startDate != null) {
			long longAfter = startDate.getTime();
			search.addFilterGreaterOrEqual("startDate", longAfter);
		}
		if (endDate != null) {
			long longBefore = endDate.getTime();
			search.addFilterLessOrEqual("startDate", longBefore);
		}
		return this.search(search);
	}

	private String getBooleanValue() {
		String value = null;
		String prop = dataSource.getDriverClassName();
		if (prop.equals("org.postgresql.Driver")) {
			value = "true";
			return value;
		} else {
			return value = "1";
		}
	}

	public List<Flow> loadAllStartedByTypeWithDateFilter(final int type,
			final Date after, final Date before) {
		long longAfter = after.getTime();
		long longBefore = before.getTime();
		final Search search = new Search();
		search.addFilterNotNull("startDate");
		search.addFilterEqual("type", type);
		search.addSortDesc("startDate");
		if (after != null) {
			search.addFilterGreaterOrEqual("startDate", longAfter);
		}
		if (before != null) {
			search.addFilterLessOrEqual("startDate", longBefore);
		}
		return this.search(search);
	}

	@SuppressWarnings("unchecked")
	public List<Flow> getFlowsByDateAndType(long date, int type, int limit) {
		String booleanValue = getBooleanValue();
		final Session session = this.getSession();

		String limitValue = getLimitValue(limit);

		String requete = "select f.id, f.idpetals from FLOW f "
				+ " left join FLOWREF fr  on fr.type = "
				+ type
				+ " left join FLOWSTEPREF ffsr on fr.id = ffsr.flowref_id and ffsr.flowstartstep = "
				+ booleanValue
				+ " left join FLOWSTEP ffs on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName  and ffs.interfaceName = ffsr.interfaceName "
				+ " where f.type = " + type + " and ffs.startDate < " + date
				+ " " + limitValue;

		//System.out.println("j'affiche la requete  " + requete);
		final Query query = session.createSQLQuery(requete)
				.setResultTransformer(Transformers.aliasToBean(Flow.class));

		final List<Flow> ret = query.list();

		return ret;
	}

	private String getLimitValue(int limit) {
		String value = null;
		String prop = dataSource.getDriverClassName();
		if (limit != 0) {
			if (prop.equals("org.postgresql.Driver")) {
				value = "LIMIT " + limit + " OFFSET 0";
			} else if (prop.equals("com.mysql.jdbc.Driver")
					|| (prop.equals("org.h2.Driver"))) {
				value = "limit 0," + limit;
			} else {
				value = "";
			}
		}else{
			value = "";
		}
		return value;
	}

}
