/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * GlobalFlowParam.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.petalsview.persistence.dao.flowref;

import java.math.BigDecimal;

public class GlobalFlowParam {
	private int idx;
	private String name;
	private String serviceName;
	private String interfaceName;
	
	
	
	public GlobalFlowParam() {
		super();
		// TODO Auto-generated constructor stub
	}


	public GlobalFlowParam(int idx, String name, String serviceName,
			String interfaceName) {
		super();
		this.idx = idx;
		this.name = name;
		this.serviceName = serviceName;
		this.interfaceName = interfaceName;
	}


	public int getIdx() {
		return idx;
	}


	public void setIdx(int idx) {
		this.idx = idx;
	}


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public String getServiceName() {
		return serviceName;
	}


	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}


	public String getInterfaceName() {
		return interfaceName;
	}


	public void setInterfaceName(String interfaceName) {
		this.interfaceName = interfaceName;
	}
	
	// ========================================================================
	// === Attributes Setters for Oracle
	// ========================================================================
	public void setIDX(Object o) {
		if (o instanceof BigDecimal) {
			String tmp = String.valueOf(o);
			int idx = Integer.valueOf(tmp);
			this.idx = idx;
		}
	}

	public void setNAME(String name) {
		this.name = name;
	}

	public void setSERVICENAME(String serviceName) {
		this.serviceName = serviceName;
	}

	public void setINTERFACENAME(String interfaceName) {
		this.interfaceName = interfaceName;
	}

	// ========================================================================
	// === Attributes Setters for PostgreSQL
	// ========================================================================
	public void setServicename(String serviceName) {
		this.serviceName = serviceName;
	}

	public void setInterfacename(String interfaceName) {
		this.interfaceName = interfaceName;
	}

}
