/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Flow.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.persistence.model.flow;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Index;

import com.ebmwebsourcing.webcommons.persistence.bo.LongIdBaseObject;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;

/**
 * This class represents a functional flow instance in Petals.
 * 
 * @author Pierre SMEYERS, ofabre
 */
@XStreamAlias("flow")
@Entity(name = "com.ebmwebsourcing.petalsview.persistence.model.flow.Flow")
@Table(name = "FLOW")
public class Flow extends LongIdBaseObject {

    private static final long serialVersionUID = 722107433353053837L;

    public static final int SUCCESS_STATUS = 0;

    public static final int IN_PROGRESS_STATUS = -1;

    // ========================================================================
    // === Attributes
    // ========================================================================

    @XStreamAlias("idpetals")
    @XStreamAsAttribute
    private String idpetals;

    @XStreamOmitField
    private Long startDate;

    @XStreamOmitField
    private Long endDate;

    @XStreamAlias("type")
    @XStreamAsAttribute
    private int type;
    
    @XStreamOmitField
    private Integer status;

    @XStreamImplicit(itemFieldName="flowStep")
    private List<FlowStep> listFlowStep;

    // ========================================================================
    // === Constructors
    // ========================================================================
    public Flow() {
    }

    // ========================================================================
    // === Attributes Getters & Setters
    // ========================================================================

    @Column(unique = true, nullable = false)
    @Index(name = "idpetalsindex")
    public String getIdpetals() {
        return this.idpetals;
    }

    public void setIdpetals(final String idpetals) {
        this.idpetals = idpetals;
    }

    @Transient
    public Long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(final Long startDate) {
        this.startDate = startDate;
    }

    @Transient
    public Long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(final Long endDate) {
        this.endDate = endDate;
    }

    @Transient
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(final Integer status) {
        this.status = status;
    }

    public int getType() {
        return this.type;
    }

    public void setType(final int type) {
        this.type = type;
    }
    
   @OneToMany(fetch = FetchType.LAZY, mappedBy = "flow", cascade=CascadeType.REMOVE)
    public List<FlowStep> getListFlowStep() {
		return listFlowStep;
	}

	public void setListFlowStep(List<FlowStep> listFlowStep) {
		this.listFlowStep = listFlowStep;
	}

	@Override
    public boolean equals(final Object other) {
        if (!(other instanceof Flow))
            return false;
        Flow castOther = (Flow) other;
        return new EqualsBuilder().append(idpetals, castOther.idpetals).append(startDate,
                castOther.startDate).append(endDate, castOther.endDate).append(status,
                castOther.status).append(type, castOther.type)/*.append(listFlowStep,castOther.listFlowStep)*/.isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(idpetals).append(startDate).append(endDate).append(
                status).append(type)./*append(listFlowStep).*/toHashCode();
    } 

    // ========================================================================
    // === Attributes Setters for Oracle
    // ========================================================================

    public void setIDPETALS(final String idpetals) {
        this.idpetals = idpetals;
    }

    public void setSTARTDATE(final Object o) {
        if (o instanceof BigDecimal) {
            String tmp = String.valueOf(o);
            long startDate = Long.valueOf(tmp);
            this.startDate = startDate;
        }
        if (o instanceof BigInteger) {
            String tmp = String.valueOf(o);
            long startDate = Long.valueOf(tmp);
            this.startDate = startDate;
        } 
    }

    public void setENDDATE(final Object o) {
        if (o instanceof BigDecimal) {
            String tmp = String.valueOf(o);
            long endDate = Long.valueOf(tmp);
            this.endDate = endDate;
        }
        if (o instanceof BigInteger) {
            String tmp = String.valueOf(o);
            long endDate = Long.valueOf(tmp);
            this.endDate = endDate;
        } 
        
    }

    public void setSTATUS(final Object o) {
        if (o instanceof BigDecimal) {
            String tmp = String.valueOf(o);
            int status = Integer.valueOf(tmp);
            this.status = status;
        }
        if (o instanceof BigInteger) {
            String tmp = String.valueOf(o);
            int status = Integer.valueOf(tmp);
            this.status = status;
        } 
    }

    public void setTYPE(final Object o) {
        if (o instanceof BigDecimal) {
            String tmp = String.valueOf(o);
            int type = Integer.valueOf(tmp);
            this.type = type;
        }
        if (o instanceof BigInteger) {
            String tmp = String.valueOf(o);
            int type = Integer.valueOf(tmp);
            this.type = type;
        } 
    }

    // ========================================================================
    // === Attributes Setters for PostgreSQL
    // ========================================================================
    public void setStartdate(final Object o) {
        if (o instanceof BigInteger) {
            String tmp = String.valueOf(o);
            long startdate = Long.valueOf(tmp);
            this.startDate = startdate;
        }
    }

    public void setEnddate(final Object o) {
        if (o instanceof BigInteger) {
            String tmp = String.valueOf(o);
            long enddate = Long.valueOf(tmp);
            this.endDate = enddate;
        }

    }

}
