/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowRef.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.persistence.model.flowref;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.ebmwebsourcing.webcommons.persistence.bo.StringIdBaseObject;

/**
 * This class represents a functional flow definition.
 * 
 * @author Pierre SMEYERS, ofabre
 */
@Entity(name = "com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef")
@Table(name = "FLOWREF")
public class FlowRef extends StringIdBaseObject {

    /**
	 * 
	 */
    private static final long serialVersionUID = 8416940635043610355L;

    // ========================================================================
    // === Attributes
    // ========================================================================

    private Date creationDate;

    private int type;

    private String name;
        
    private int referenceTime;
    
    private boolean save;
    
    private String urlBackup;
    
    private String fileName;
    
    private int limitValue;

    // ========================================================================
    // === Constructors
    // ========================================================================

    // ========================================================================
    // === Attributes Getters & Setters
    // ========================================================================

    @Column(unique = true)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Temporal(TemporalType.TIMESTAMP)
    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Column(unique = true)
    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }
    
	public int getReferenceTime() {
		return referenceTime;
	}

	public void setReferenceTime(Integer referenceTime) {
		if(referenceTime == null){
			referenceTime = 0;
		}
		this.referenceTime = referenceTime;
	}
	
	

	/**
	 * @return the save
	 */
	public boolean isSave() {
		return save;
	}

	/**
	 * @param save the save to set
	 */
	public void setSave(boolean save) {
		this.save = save;
	}

	/**
	 * @return the url
	 */
	public String getUrlBackup() {
		return urlBackup;
	}

	/**
	 * @param url the url to set
	 */
	public void setUrlBackup(String urlBackup) {
		this.urlBackup = urlBackup;
	}

	/**
	 * @return the fileName
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * @param fileName the fileName to set
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * @return the limit
	 */
	public int getLimitValue() {
		return limitValue;
	}

	/**
	 * @param limit the limit to set
	 */
	public void setLimitValue(Integer limitValue) {
		if(limitValue == null){
			limitValue = 0;
		}
		this.limitValue = limitValue;
	}

	@Override
    public boolean equals(final Object other) {
        if (!(other instanceof FlowRef))
            return false;
        FlowRef castOther = (FlowRef) other;
        return new EqualsBuilder().append(creationDate, castOther.creationDate).append(type,
                castOther.type).append(name, castOther.name).append(referenceTime, castOther.referenceTime).isEquals();
    }

	@Override
	public int hashCode() {
		return new HashCodeBuilder().append(creationDate).append(type).append(
				name).append(referenceTime).toHashCode();
	}
	
	@Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
                super.toString()).append("name", this.name)
               .toString();
    }

}
