/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.notification;

import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flow.FlowStepDAO;
import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.service.notification.Notification;
import com.ebmwebsourcing.petalsview.service.notification.NotificationProcessingException;
import com.ebmwebsourcing.petalsview.service.notification.NotificationProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="notificationProcessor")
public class NotificationProcessorImpl
implements NotificationProcessor {
    @Resource(name="flowDAO")
    private FlowDAO flowDAO;
    @Resource(name="flowStepDAO")
    private FlowStepDAO flowStepDAO;
    private Map<String, Flow> flowMap = new ConcurrentHashMap<String, Flow>();
    private Map<String, FlowStep> flowStepMap = new ConcurrentHashMap<String, FlowStep>();

    @Override
    public void process(List<Notification> notificationList) throws NotificationProcessingException {
        if (notificationList != null) {
            for (Notification notification : notificationList) {
                if (notification == null || !notification.isValid()) continue;
                Flow flow = this.createOrRetrieveFlow(notification);
                this.createOrRetrieveFlowStep(notification, flow);
            }
        } else {
            throw new NotificationProcessingException("Can't process a null notification list");
        }
        this.save();
    }

    private void createOrRetrieveFlowStep(Notification notification, Flow flow) throws NotificationProcessingException {
        FlowStep flowStep = this.retrieveFlowStep(notification);
        if (flowStep == null) {
            this.createFlowStep(notification, flow);
        }
        this.updateFlowStep(notification);
    }

    private Flow createOrRetrieveFlow(Notification notification) {
        Flow flow = null;
        flow = this.retrieveFlow(notification);
        if (flow == null) {
            flow = this.createFlow(notification);
        }
        return flow;
    }

    private void save() {
        Collection<Flow> flowCollection = this.flowMap.values();
        for (Flow flow : flowCollection) {
            this.flowDAO.save((Object)flow);
        }
        Collection<FlowStep> flowStepCollection = this.flowStepMap.values();
        for (FlowStep flowStep : flowStepCollection) {
            this.flowStepDAO.save((Object)flowStep);
        }
        this.flowMap.clear();
        this.flowStepMap.clear();
    }

    private FlowStep retrieveFlowStep(Notification notification) {
        FlowStep flowStep = null;
        flowStep = this.flowStepMap.get(notification.getMeUUID());
        if (flowStep == null && (flowStep = this.flowStepDAO.loadByMeUUID(notification.getMeUUID())) != null) {
            this.flowStepMap.put(flowStep.getMeUUID(), flowStep);
        }
        return flowStep;
    }

    private Flow retrieveFlow(Notification notification) {
        Flow flow = null;
        flow = this.flowMap.get(notification.getProcessId());
        if (flow == null && (flow = this.flowDAO.loadByPetalsId(notification.getProcessId())) != null) {
            this.flowMap.put(flow.getIdpetals(), flow);
        }
        return flow;
    }

    private Flow createFlow(Notification notification) {
        Flow flow = new Flow();
        flow.setIdpetals(notification.getProcessId());
        flow.setType(notification.getProcessType());
        this.flowMap.put(flow.getIdpetals(), flow);
        return flow;
    }

    private FlowStep createFlowStep(Notification notification, Flow flow) throws NotificationProcessingException {
        FlowStep flowStep = new FlowStep();
        flowStep.setEndpointName(notification.getEndpointName());
        flowStep.setInterfaceName(notification.getInterfaceName());
        flowStep.setServiceName(notification.getServiceName());
        flowStep.setMeUUID(notification.getMeUUID());
        flowStep.setStatus(-1);
        flowStep.setFlow(flow);
        this.flowStepMap.put(flowStep.getMeUUID(), flowStep);
        return flowStep;
    }

    private FlowStep updateFlowStep(Notification notification) throws NotificationProcessingException {
        FlowStep flowStep = this.flowStepMap.get(notification.getMeUUID());
        if (flowStep != null) {
            switch (notification.getStatus()) {
                case -1: {
                    Date date = notification.getNotifDate();
                    long startDate = date.getTime();
                    flowStep.setStartDate(Long.valueOf(startDate));
                    ArrayList<String> paramList = new ArrayList<String>();
                    if (notification.getParams() != null && !notification.getParams().isEmpty()) {
                        paramList.addAll(notification.getParams());
                    }
                    if (flowStep.getParameters() != null && !flowStep.getParameters().isEmpty()) {
                        paramList.addAll(flowStep.getParameters());
                    }
                    flowStep.setParameters(paramList);
                    break;
                }
                default: {
                    if (notification.getStatus() < -1) {
                        throw new NotificationProcessingException("Try to process an unsupported notif status: " + notification.getStatus());
                    }
                    flowStep.setStatus(notification.getStatus());
                    Date date = notification.getNotifDate();
                    long endDate = date.getTime();
                    flowStep.setEndDate(Long.valueOf(endDate));
                    ArrayList<String> paramList = new ArrayList<String>();
                    if (flowStep.getParameters() != null && !flowStep.getParameters().isEmpty()) {
                        paramList.addAll(flowStep.getParameters());
                    }
                    if (notification.getParams() != null && !notification.getParams().isEmpty()) {
                        paramList.addAll(notification.getParams());
                    }
                    flowStep.setParameters(paramList);
                }
            }
            this.flowStepMap.put(flowStep.getMeUUID(), flowStep);
        }
        return flowStep;
    }
}

