/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.referential;

import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.StepParameter;
import com.ebmwebsourcing.petalsview.service.flow.FlowException;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManagerRuntimeException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.LocalizedError;

public class StepRefDetails {
    private String interfaceName;
    private String serviceName;
    private String endpointName;
    private String functionalName;
    private boolean startStep = false;
    private boolean endStep = false;
    private String successMessage;
    private String defaultErrorMessage;
    private int flowRefType;
    private FlowStepRef flowStepRef;
    private String[] selectedErrorIds;
    private int[] selectedParamIndexes;
    private int[] paramIndex;
    private List<String> allStepUnknownParameters;
    private int numberOfUnknownParams;
    private FlowRefManager flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
    private FlowStepRefManager flowStepRefManager;
    private FlowStepManager flowStepManager = PetalsViewServiceFactory.getInstance().getFlowStepManager();

    public StepRefDetails() {
        this.flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();
    }

    public void load(HttpServletRequest request) throws Exception {
        String id = request.getParameter("id");
        this.flowRefType = Integer.parseInt(request.getParameter("flowRefType"));
        this.loadStepRef(id);
        this.paramIndex = new int[this.flowStepRef.getParameterNames().size()];
        for (int i = 0; i < this.paramIndex.length; ++i) {
            this.paramIndex[i] = i;
        }
        this.loadUnknownParameters();
    }

    private void loadUnknownParameters() throws Exception {
        this.allStepUnknownParameters = this.flowStepManager.loadUnknownParameters(this.flowStepRef.getInterfaceName(), this.flowStepRef.getServiceName());
        if (this.allStepUnknownParameters != null && !this.allStepUnknownParameters.isEmpty()) {
            int i;
            ArrayList<String> listTmp = new ArrayList<String>();
            for (i = 0; i < this.flowStepRef.getParameterNames().size(); ++i) {
                listTmp.add(((StepParameter)this.flowStepRef.getParameterNames().get(i)).getName());
            }
            for (i = 0; i < this.allStepUnknownParameters.size(); ++i) {
                if ((listTmp == null || listTmp.isEmpty()) && this.allStepUnknownParameters.size() <= listTmp.size()) continue;
                this.numberOfUnknownParams = this.allStepUnknownParameters.size() - listTmp.size();
                if (this.numberOfUnknownParams >= 0) continue;
                this.numberOfUnknownParams = 0;
            }
        }
    }

    private void loadFlowParams(String id) throws Exception {
        this.flowStepRef = this.flowStepRefManager.loadStepRef(id);
        this.selectedParamIndexes = new int[0];
    }

    public void init(HttpServletRequest request) throws FlowException {
        this.flowRefType = Integer.parseInt(request.getParameter("flowRefType"));
        String idStep = request.getParameter("idStep");
        if (idStep != null && !idStep.equals("0")) {
            FlowStep flowStep = this.flowStepManager.loadFlowStep(idStep);
            this.interfaceName = flowStep.getInterfaceName();
            this.serviceName = flowStep.getServiceName();
        }
    }

    private void loadStepRef(String id) throws Exception {
        this.flowStepRef = this.flowStepRefManager.loadStepRef(id);
        this.reset();
    }

    public void reset() {
        this.interfaceName = this.flowStepRef.getInterfaceName();
        this.serviceName = this.flowStepRef.getServiceName();
        this.functionalName = this.flowStepRef.getName();
        this.startStep = this.flowStepRef.isFlowStartStep();
        this.endStep = this.flowStepRef.isFlowEndStep();
        this.successMessage = this.flowStepRef.getSuccessMessage();
        this.defaultErrorMessage = this.flowStepRef.getDefaultErrorMessage();
        this.selectedErrorIds = new String[0];
    }

    public String create() throws LocalizedError, Exception {
        FlowStepRef flowStepRef = new FlowStepRef();
        flowStepRef.setFlowEndStep(this.endStep);
        flowStepRef.setFlowref(this.flowRefManager.getFlowRef(this.flowRefType));
        flowStepRef.setFlowStartStep(this.startStep);
        flowStepRef.setInterfaceName(this.interfaceName);
        flowStepRef.setName(this.functionalName);
        flowStepRef.setServiceName(this.serviceName);
        flowStepRef.setSuccessMessage(this.successMessage);
        flowStepRef.setDefaultErrorMessage(this.defaultErrorMessage);
        try {
            this.flowStepRefManager.saveOrUpdateStepRef(flowStepRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowstepref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefManagerRuntimeException e) {
            LocalizedError le = new LocalizedError("create_flowstepref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        return "success";
    }

    public String update() throws LocalizedError, Exception {
        this.flowStepRef.setFlowEndStep(this.endStep);
        this.flowStepRef.setFlowStartStep(this.startStep);
        this.flowStepRef.setInterfaceName(this.interfaceName);
        this.flowStepRef.setName(this.functionalName);
        this.flowStepRef.setServiceName(this.serviceName);
        this.flowStepRef.setSuccessMessage(this.successMessage);
        this.flowStepRef.setDefaultErrorMessage(this.defaultErrorMessage);
        this.flowStepRef.setFlowref(this.flowRefManager.getFlowRef(this.flowRefType));
        try {
            this.flowStepRefManager.saveOrUpdateStepRef(this.flowStepRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("update_flowstepref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefManagerRuntimeException e) {
            LocalizedError le = new LocalizedError("update_flowstepref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        return "success";
    }

    public String removeErrorRefs() throws Exception {
        this.flowStepRefManager.removeErrorRefs(this.selectedErrorIds);
        this.loadStepRef(this.flowStepRef.getId());
        return "success";
    }

    public int[] makeIndexes(int size) {
        int[] ret = new int[size];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public String addParameterName(int index, String name, boolean global) throws Exception {
        this.flowStepRefManager.addParameterName(this.flowStepRef.getId(), index, name, global);
        this.loadFlowParams(this.flowStepRef.getId());
        this.loadUnknownParameters();
        return "success";
    }

    public String updateParameterName(int index, String name, boolean global) throws Exception {
        this.flowStepRefManager.updateParameterName(this.flowStepRef.getId(), index, name, global);
        this.loadFlowParams(this.flowStepRef.getId());
        return "success";
    }

    public String removeParameterNames() throws Exception {
        this.flowStepRefManager.removeParameterNames(this.flowStepRef.getId(), this.selectedParamIndexes);
        this.loadFlowParams(this.flowStepRef.getId());
        this.loadUnknownParameters();
        return "success";
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public int[] getParamIndex() {
        return this.paramIndex;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getFunctionalName() {
        return this.functionalName;
    }

    public void setFunctionalName(String functionalName) {
        this.functionalName = functionalName;
    }

    public boolean isStartStep() {
        return this.startStep;
    }

    public void setStartStep(boolean startStep) {
        this.startStep = startStep;
    }

    public boolean isEndStep() {
        return this.endStep;
    }

    public void setEndStep(boolean endStep) {
        this.endStep = endStep;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public FlowStepRef getFlowStepRef() {
        return this.flowStepRef;
    }

    public void setFlowStepRef(FlowStepRef flowStepRef) {
        this.flowStepRef = flowStepRef;
    }

    public int getFlowRefType() {
        return this.flowRefType;
    }

    public void setFlowRefType(int flowRefType) {
        this.flowRefType = flowRefType;
    }

    public String[] getSelectedErrorIds() {
        return this.selectedErrorIds;
    }

    public void setSelectedErrorIds(String[] selectedErrorIds) {
        this.selectedErrorIds = selectedErrorIds;
    }

    public Collection<FlowStepErrorRef> getErrorMessages() {
        ArrayList flowErrorStepRefs = null;
        if (this.flowStepRef.getErrorMessages() != null && this.flowStepRef.getErrorMessages().size() != 0) {
            flowErrorStepRefs = new ArrayList();
            flowErrorStepRefs.addAll(this.flowStepRef.getErrorMessages().values());
            Collections.sort(flowErrorStepRefs);
        }
        return flowErrorStepRefs;
    }

    public String getDefaultErrorMessage() {
        return this.defaultErrorMessage;
    }

    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public int[] getSelectedParamIndexes() {
        return this.selectedParamIndexes;
    }

    public void setSelectedParamIndexes(int[] selectedParamIndexes) {
        this.selectedParamIndexes = selectedParamIndexes;
    }

    public List<String> getAllStepUnknownParameters() {
        return this.allStepUnknownParameters;
    }

    public void setAllStepUnknownParameters(List<String> allStepUnknownParameters) {
        this.allStepUnknownParameters = allStepUnknownParameters;
    }

    public int getNumberOfUnknownParams() {
        return this.numberOfUnknownParams;
    }

    public void setNumberOfUnknownParams(int numberOfUnknownParams) {
        this.numberOfUnknownParams = numberOfUnknownParams;
    }
}

