/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.supervision;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class ListOfFlows {
    private static int[] ALL_STATUS = new int[]{0, 1, 2};
    private List<Flow> flows;
    private Date before;
    private Date after;
    private FlowManager flowManager = PetalsViewServiceFactory.getInstance().getFlowManager();

    public void loadAll() throws Exception {
        this.setupFilterToday();
        this.flows = this.flowManager.loadAllStartedWithDateFilter(this.after, this.before);
    }

    private void setupFilterToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.after = cal.getTime();
        cal.add(5, 1);
        this.before = cal.getTime();
    }

    public String getShortName(Flow flow) {
        String shortName = flow.getIdpetals();
        if (shortName != null) {
            if (shortName.length() > 30) {
                shortName = shortName.substring(0, 27) + "...";
            }
        } else {
            shortName = " ";
        }
        return shortName;
    }

    public String getName(Flow flow) {
        String name = flow.getIdpetals();
        return name;
    }

    public void viewAllFlow() throws Exception {
        this.after = null;
        this.before = null;
        this.flows = new ArrayList();
        this.flows = this.flowManager.loadAll();
    }

    public void validateFilter() throws ValidationErrors {
        System.out.println("--> validate");
        Date now = new Date();
        ValidationErrors errors = new ValidationErrors();
        if (this.after != null && this.after.after(now)) {
            System.out.println("--> future");
            errors.addItemError("flows.after", (ValidationError)new LocalizedValidationError("validation.date.future"));
        }
        if (this.before != null && this.after != null && this.after.after(this.before)) {
            System.out.println("--> negative range");
            errors.addItemError("flows.before", (ValidationError)new LocalizedValidationError("validation.date.negative_range"));
        }
        if (errors.hasErrors()) {
            System.out.println("--> throw");
            throw errors;
        }
    }

    public void applyFilter() throws Exception {
        this.flows = this.flowManager.loadAllStartedWithDateFilter(this.after, this.before);
    }

    public void refresh() throws Exception {
        if (this.after == null && this.before == null) {
            this.viewAllFlow();
        } else {
            this.setupFilterToday();
            this.flows = this.flowManager.loadAllStartedWithDateFilter(this.after, this.before);
        }
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public static int[] getAllStatus() {
        return ALL_STATUS;
    }

    public Date getBefore() {
        return this.before;
    }

    public void setBefore(Date before) {
        this.before = before;
    }

    public Date getAfter() {
        return this.after;
    }

    public void setAfter(Date after) {
        this.after = after;
    }

    public int getUiStatus(int status) {
        if (status == 0) {
            return 0;
        }
        if (status == -1) {
            return 2;
        }
        return 1;
    }
}

