/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowReferential.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.referential;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;

import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;

import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.StepParameter;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

public class FlowReferential {
	
	//private final Logger logger = Logger.getLogger(this.getClass());
	
    private FlowRef flowRef;

    private List<FlowStepRef> stepRefs;

    private String[] selectedSteps;

    private List<FlowStep> unknowsSteps;

    private FlowRefManager flowRefManager;
    private FlowStepManager flowStepManager;
    private FlowStepRefManager flowStepRefManager;

    private boolean viewUnkownStep;

    private int type;

    private String idFlow;

    private String name;

    private String id;
    
    
    //Attributs for purge

    boolean editableCreate;
    boolean editableDelete;
    boolean backup;
	int referenceTime;
	String urlBackup;

    public FlowReferential() {
        super();
        this.flowStepManager = PetalsViewServiceFactory.getInstance().getFlowStepManager();
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
        this.flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();
    }

    // ===========================================================
    // === Control Methods
    // ===========================================================
    public void load(HttpServletRequest request) throws Exception, IError{
        type = Integer.parseInt(request.getParameter("type"));
        idFlow = request.getParameter("idFlow");

        loadFlowRef(type);
        loadStepRefs(type);
        
    }

    private void loadFlowRef(int type) {
        flowRef = flowRefManager.getFlowRef(type);
        type = flowRef.getType();
        name = flowRef.getName();
        id = flowRef.getId();
        referenceTime = flowRef.getReferenceTime();
        
        if(referenceTime == 0){
        	 editableCreate = true;
             editableDelete = false;
        }
        else {
        	editableCreate = false;
            editableDelete = true;
        }
       
        backup = true;
        
        

    }

    private void loadStepRefs(int type) throws Exception, IError{
        stepRefs = flowStepRefManager.loadSteps(type);
        selectedSteps = new String[0];

     
    	   unknowsSteps = flowStepManager.loadSteps(idFlow, type);
       
        if (unknowsSteps != null && !unknowsSteps.isEmpty()) {
            removeStepWithReferential(type);
        } else {
            viewUnkownStep = false;
        }

    }

    public void save() throws Exception {
        try {
            FlowRef flowRef = new FlowRef();
            flowRef.setId(id);
            flowRef.setName(name);
            flowRef.setType(type);

            flowRefManager.update(flowRef);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        }catch (FlowRefException e){
            NonLocalizedError error = new NonLocalizedError("create_flowref.constraint", null, e);
            error.setType(IError.FUNCTIONAL_ERROR);
            throw error;
    }

        // refresh ReferentialBean
        ReferentialBean.reload();
    }

    // --- Steps Management Methods
    public void removeStepRefs() throws Exception,IError{

    	flowStepRefManager.removeStepRefs(selectedSteps);
        loadStepRefs(flowRef.getType());

    }

    public String getStepName(FlowStep flowStep) {
        String result = "";

        result = flowStep.getInterfaceName() + "/" + flowStep.getServiceName();

        return result;
    }

    public String getShortStepName(FlowStep flowStep) {
        String result = "";

        result = flowStep.getInterfaceName() + "/" + flowStep.getServiceName();
        if (result.length() > 30) {
            String shortIntName = QName.valueOf(flowStep.getInterfaceName()).getLocalPart()
                    .length() > 11 ? QName.valueOf(flowStep.getInterfaceName()).getLocalPart()
                    .substring(0, 10)
                    + "..." : QName.valueOf(flowStep.getInterfaceName()).getLocalPart();
            String shortServName = QName.valueOf(flowStep.getServiceName()).getLocalPart().length() > 11 ? QName
                    .valueOf(flowStep.getServiceName()).getLocalPart().substring(0, 10)
                    + "..."
                    : QName.valueOf(flowStep.getServiceName()).getLocalPart();
            result = shortIntName + "/" + shortServName;
        }

        return result;
    }

    private void removeStepWithReferential(int type) throws IError {
        int i = 0;
        List<FlowStep> flowStepsTmp = new ArrayList<FlowStep>();
        FlowStepRef flowStepRefTmp = new FlowStepRef ();

        for (FlowStep fS : unknowsSteps) {
            flowStepsTmp.add(fS);
        }

        for (i = 0; i < unknowsSteps.size(); i++) {

        	try{
        		 flowStepRefTmp = flowStepRefManager.loadStepRef(unknowsSteps.get(i).getFlow()
                         .getType(), unknowsSteps.get(i).getInterfaceName(), unknowsSteps.get(i)
                         .getServiceName());
        	}catch (FlowRefException e){
        		NonLocalizedError error = new NonLocalizedError("Can't remove step referential.", e.getMessage(), e);
                error.setType(IError.FUNCTIONAL_ERROR);
                throw error;
        	}
           
            if (flowStepRefTmp != null) {
                FlowStep fS = unknowsSteps.get(i);
                flowStepsTmp.remove(fS);
            }
        }
        unknowsSteps = flowStepsTmp;
        if (unknowsSteps.size() != 0) {
            viewUnkownStep = true;
        } else {
            viewUnkownStep = false;
        }
    }

    public void reset() {
        // do nothing
    }
    
    /*
     * Methods for purge database
     */
    
   
    
    public void createPurge () throws Exception{
    	
    	editableCreate = false;
    	editableDelete = true;
    	
    	 try {
             FlowRef flowRef = new FlowRef();
             flowRef.setId(id);
             flowRef.setName(name);
             flowRef.setType(type);	
             flowRef.setReferenceTime(referenceTime);

             flowRefManager.update(flowRef);
         } catch (ConstraintViolationException e) {
             LocalizedError le = new LocalizedError("create_flowref.constraint", e);
             le.setType(IError.FUNCTIONAL_ERROR);
             throw le;
         } catch (HibernateException e) {
             throw new LocalizedError("database", e);
         }catch (FlowRefException e){
             NonLocalizedError error = new NonLocalizedError("create_flowref.constraint", null, e);
             error.setType(IError.FUNCTIONAL_ERROR);
             throw error;
     }

    }
    
    public void deletePurge () throws Exception{
    	 try {
             FlowRef flowRef = new FlowRef();
             flowRef.setId(id);
             flowRef.setName(name);
             flowRef.setType(type);	
             flowRef.setReferenceTime(0);

             flowRefManager.update(flowRef);
         } catch (ConstraintViolationException e) {
             LocalizedError le = new LocalizedError("create_flowref.constraint", e);
             le.setType(IError.FUNCTIONAL_ERROR);
             throw le;
         } catch (HibernateException e) {
             throw new LocalizedError("database", e);
         }catch (FlowRefException e){
             NonLocalizedError error = new NonLocalizedError("create_flowref.constraint", null, e);
             error.setType(IError.FUNCTIONAL_ERROR);
             throw error;
     }
    	
    	referenceTime = 0;
    	backup = true;
    	urlBackup = null;
    	editableDelete = false;
    	editableCreate = true;
    }

    // ===========================================================
    // === Getters/Setters
    // ===========================================================
    public FlowRef getFlowRef() {
        return flowRef;
    }

    public List<FlowStepRef> getStepRefs() {
        return stepRefs;
    }

    public String[] getSelectedSteps() {
        return selectedSteps;
    }

    public void setSelectedSteps(String[] selectedSteps) {
        this.selectedSteps = selectedSteps;
    }

    // ===========================================================
    // --- Helper Methods for GUI
    // ===========================================================
    public String buildErrorMessagesHtml(FlowStepRef step) {
        Map<Integer, FlowStepErrorRef> errorMessages = step.getErrorMessages();
        String defaultErrorMessage = step.getDefaultErrorMessage();
        if ((defaultErrorMessage == null || "".equals(defaultErrorMessage))
                && (errorMessages == null || errorMessages.size() == 0))
            return null;
        Collection<FlowStepErrorRef> errors = errorMessages.values();
        StringBuffer sb = new StringBuffer();
        sb.append("\\html\\");
        sb.append("<ul class=list>\n");
        for (FlowStepErrorRef error : errors) {
            sb.append("<li>");
            sb.append(String.valueOf(error.getErrorCode()));
            sb.append(": ");
            sb.append(error.getMessage());
            sb.append("</li>\n");
        }
        if (defaultErrorMessage != null || !("".equals(defaultErrorMessage))) {
            sb.append("<li>");
            sb.append("default");
            sb.append(": ");
            sb.append(defaultErrorMessage);
            sb.append("</li>\n");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public String getShortStepKey(FlowStepRef step) {
        String result = step.getInterfaceName() + "/" + step.getServiceName();
        if (result.length() > 50) {
            String shortIntName = QName.valueOf(step.getInterfaceName()).getLocalPart().length() > 21 ? QName
                    .valueOf(step.getInterfaceName()).getLocalPart().substring(0, 20)
                    + "..."
                    : QName.valueOf(step.getInterfaceName()).getLocalPart();
            String shortServName = QName.valueOf(step.getServiceName()).getLocalPart().length() > 21 ? QName
                    .valueOf(step.getServiceName()).getLocalPart().substring(0, 20)
                    + "..."
                    : QName.valueOf(step.getServiceName()).getLocalPart();
            result = shortIntName + "/" + shortServName;
        }
        return result;
    }

    public String getStepName(FlowStepRef step) {
        return step.getName();
    }

    public String getShortStepName(FlowStepRef step) {
        String result = "";
        if (step.getName().length() > 50) {
            result = step.getName().substring(0, 46) + "...";
        } else {
            result = step.getName();
        }
        return result;
    }

    public String getStepKey(FlowStepRef step) {
        return step.getInterfaceName() + "/" + step.getServiceName();
    }

    public List<FlowRefParameter> getFlowParameters() {
        List<FlowRefParameter> result = new ArrayList<FlowRefParameter>();
        if (stepRefs != null) {
            for (FlowStepRef stepRef : stepRefs) {
                if (stepRef.getParameterNames() != null) {
                    for (StepParameter stepParameter : stepRef.getParameterNames()) {
                        if (stepParameter.isGlobal()) {
                            result.add(new FlowRefParameter(stepParameter, stepRef));
                        }
                    }
                }
            }
        }
        return result;
    }

    public class FlowRefParameter {
        private StepParameter parameter;

        private FlowStepRef stepRef;

        public StepParameter getParameter() {
            return parameter;
        }

        public void setParameter(StepParameter parameter) {
            this.parameter = parameter;
        }

        public FlowStepRef getStepRef() {
            return stepRef;
        }

        public void setStepRef(FlowStepRef stepRef) {
            this.stepRef = stepRef;
        }

        public FlowRefParameter() {
            super();
        }

        public FlowRefParameter(StepParameter parameter, FlowStepRef stepRef) {
            super();
            this.parameter = parameter;
            this.stepRef = stepRef;
        }
    }

    public List<FlowStep> getUnknowsSteps() {
        return unknowsSteps;
    }

    public void setUnknowsSteps(List<FlowStep> unknowsSteps) {
        this.unknowsSteps = unknowsSteps;
    }

    public boolean isViewUnkownStep() {
        return viewUnkownStep;
    }

    public void setViewUnkownStep(boolean viewUnkownStep) {
        this.viewUnkownStep = viewUnkownStep;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getIdFlow() {
        return idFlow;
    }

    public void setIdFlow(String idFlow) {
        this.idFlow = idFlow;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

	

	public boolean isEditableCreate() {
		return editableCreate;
	}

	public void setEditableCreate(boolean editableCreate) {
		this.editableCreate = editableCreate;
	}

	public boolean isEditableDelete() {
		return editableDelete;
	}

	public void setEditableDelete(boolean editableDelete) {
		this.editableDelete = editableDelete;
	}

	public boolean isBackup() {
		return backup;
	}

	public void setBackup(boolean backup) {
		this.backup = backup;
	}

	public int getReferenceTime() {
		return referenceTime;
	}

	public void setReferenceTime(int referenceTime) {
		this.referenceTime = referenceTime;
	}

	public String getUrlBackup() {
		return urlBackup;
	}

	public void setUrlBackup(String urlBackup) {
		this.urlBackup = urlBackup;
	}
    
    

}
