/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ReferentialBean.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.referential;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.ow2.opensuit.core.session.OpenSuitSession;
import org.ow2.opensuit.core.util.BeanUtils;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef; //import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

public class ReferentialBean {
    private List<FlowRef> flowRefs;

    private Map<Integer, FlowRef> typeToRef;

    // private FlowManager flowManager;
    private FlowRefManager flowRefManager;

    public static void reload() throws Exception {
        ((ReferentialBean) BeanUtils.getOpenSuitBean(OpenSuitSession.getCurrentRequest(),
                "referentialBean")).load();
    }

    public ReferentialBean() {
        super();
        load();
    }

    private void load() {
        // this.flowManager =
        // PetalsViewServiceFactory.getInstance().getFlowManager();
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
        flowRefs = flowRefManager.loadAll();
        typeToRef = new HashMap<Integer, FlowRef>();
        for (FlowRef fr : flowRefs)
            typeToRef.put(fr.getType(), fr);
    }

    public List<FlowRef> getAllFlows() {
        return flowRefs;
    }

    public FlowRef getFlowRef(int type) {
        return typeToRef.get(type);
    }

    public String getFlowRefName(int type) {
        String result = "Unknown";
        FlowRef flowRef = typeToRef.get(type);
        if (flowRef != null) {
            result = flowRef.getName();
        }
        return result;
    }

    public String getFlowRefName(HttpServletRequest request) {
        String result = "Unknown";
        int type = Integer.parseInt(request.getParameter("type"));
        FlowRef flowRef = typeToRef.get(type);
        if (flowRef != null) {
            result = flowRef.getName();
        }

        return result;
    }
}
