/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowDetails.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.supervision;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowParamsDetails;
import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

public class FlowDetails {
    private Flow flow;

    private List<FlowStep> steps;

    private FlowRef flowRef;

    private FlowManager flowManager;

    private FlowRefManager flowRefManager;
    
    private FlowStepManager flowStepManager;
    private FlowStepRefManager flowStepRefManager;

    private List<FlowParamsDetails> listFlowParamsDetails = new ArrayList<FlowParamsDetails>();

    FlowStepRef flowStepRef = new FlowStepRef();

    public FlowDetails() {
        super();
        this.flowManager = PetalsViewServiceFactory.getInstance().getFlowManager();
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
        this.flowStepManager = PetalsViewServiceFactory.getInstance().getFlowStepManager();
        this.flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();
    }

    public void load(HttpServletRequest request) throws Exception{
        String id = request.getParameter("id");
        flow = flowManager.load(id);
        if (flow.getStatus() == null) {
            flow.setStatus(-1);
        }
        steps = flowStepManager.loadSteps(id, flow.getType());
        // flowRef = flowRefManager.getFlowRef(flow.getType());
        listFlowParamsDetails = flowRefManager.getDetailFlowParameter((short) flow.getType(), id);

    }

    public void refresh() throws Exception{
        flow = flowManager.load(flow.getIdpetals());
        if (flow.getStatus() == null) {
            flow.setStatus(-1);
        }
        steps = flowStepManager.loadSteps(flow.getIdpetals(), flow.getType());
        // flowRef = flowRefManager.getFlowRef(flow.getType());
        listFlowParamsDetails = flowRefManager.getDetailFlowParameter((short) flow.getType(), flow
                .getIdpetals());

    }

    public Flow getFlow() {
        return flow;
    }

    public Flow[] getFlows() {
        return new Flow[] { flow };
    }

    public List<FlowStep> getSteps() {
        return steps;
    }

    public FlowRef getFlowRef() {
        return flowRef;
    }

    public String getFlowType() {
        String result = "Undefined flow type";
        if (flowRef != null) {
            result = flowRef.getName();
        }
        return result;
    }

    public List<FlowParamsDetails> getListFlowParamsDetails() {
        return listFlowParamsDetails;
    }

    public String getShortStepName(FlowStep step) throws Exception {
        String result = "";
        flowStepRef = flowStepRefManager.loadStepRef(flow.getType(), step.getInterfaceName(), step
                .getServiceName());
        // If a flow ref is defined, we could use an explicit step name*/
        if (flowStepRef != null) {
            result = flowStepRef.getName();
            if (result.length() > 30) {
                result = result.substring(0, 27) + "...";
            }
        } else {
            // By default, a step name is a concatenation of the interface name
            // and service name
            result = step.getInterfaceName() + "/" + step.getServiceName();
            if (result.length() > 30) {
                String shortIntName = QName.valueOf(step.getInterfaceName()).getLocalPart()
                        .length() > 11 ? QName.valueOf(step.getInterfaceName()).getLocalPart()
                        .substring(0, 10)
                        + "..." : QName.valueOf(step.getInterfaceName()).getLocalPart();
                String shortServName = QName.valueOf(step.getServiceName()).getLocalPart().length() > 11 ? QName
                        .valueOf(step.getServiceName()).getLocalPart().substring(0, 10)
                        + "..."
                        : QName.valueOf(step.getServiceName()).getLocalPart();
                result = shortIntName + "/" + shortServName;
            }
        }

        return result;
    }

    public String getStepName(FlowStep step) {
        String result = "";

        // flowStepRef = flowRefManager.loadStepRef(flow.getType(),
        // step.getInterfaceName(), step.getServiceName());
        // If a flow ref is defined, we could use an explicit step name
        if (flowStepRef != null) {
            result = flowStepRef.getName();
        } else {
            // By default, a step name is a concatenation of the interface name
            // and service name
            result = step.getInterfaceName() + "/" + step.getServiceName();
        }

        return result;
    }

    public String getStepKey(FlowStep step) {
        return step.getInterfaceName() + "/" + step.getServiceName() + "/" + step.getEndpointName()
                + "/" + step.getMeUUID();
    }

    /**
     * Convert a flow status into a ui status (in_progress = 2, success = 0,
     * failure = 1)
     * 
     * @param status
     * @return
     */
    public int getUiStatus(int status) {
        if (status == Flow.SUCCESS_STATUS)
            return 0;
        else if (status == Flow.IN_PROGRESS_STATUS)
            return 2;
        else
            return 1;
    }

    public String getStepMessage(FlowStep step) throws Exception {
        String result = "No messages defined for this step";
        // Retrieve the corresponding step ref
        FlowStepRef flowStepRef = flowStepRefManager.loadStepRef(flow.getType(), step
                .getInterfaceName(), step.getServiceName());
        if (flowStepRef != null) {
            if (step.getStatus() == Flow.SUCCESS_STATUS) {
                result = flowStepRef.getSuccessMessage();
            } else if (step.getStatus() == Flow.IN_PROGRESS_STATUS) {
                result = null;
            } else {
                // --- cas d'erreur
                FlowStepErrorRef error = flowStepRef.getErrorMessages().get(step.getStatus());
                if (error == null) {
                    // --- error code not registered
                    result = flowStepRef.getDefaultErrorMessage() != null ? flowStepRef
                            .getDefaultErrorMessage() : "Error " + step.getStatus() + " (?)";
                } else {
                    result = error.getMessage();
                }
            }
        }
        return result;
    }

}
