/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ListOfFlowWithParams.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.supervision;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowWithParams;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.GlobalFlowParam;
import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow; //import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

public class ListOfFlowWithParams {
    private static int[] ALL_STATUS = { 0 /* success */, 1 /* error */, 2 /*
                                                                           * in
                                                                           * progress
                                                                           */};
    private String flowRefName;
    
    private int type = -1;

    private int[] paramIndex;

    private Date before;

    private Date after;

    // private FlowManager flowManager;
    private FlowRefManager flowRefManager;
    
    private FlowManager flowManager;

    private List<GlobalFlowParam> listGlobalFlowParam = new ArrayList<GlobalFlowParam>();

    private List<FlowWithParams> listFlowWithParams = new ArrayList<FlowWithParams>();

    public ListOfFlowWithParams() {
        super();
         this.flowManager = PetalsViewServiceFactory.getInstance().getFlowManager();
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
    }

    public void loadByType(HttpServletRequest request) {
        type = Integer.parseInt(request.getParameter("type"));
        // resetFilter();
        setupFilterToday();

        listGlobalFlowParam = flowRefManager.getGlobalFlowParameters((short) type);
        paramIndex = new int[listGlobalFlowParam.size()];
        listFlowWithParams = flowRefManager.getFlowsWithParameters(listGlobalFlowParam,
                (short) type, after, before);

        for (int i = 0; i < paramIndex.length; i++) {
            paramIndex[i] = i;
        }
    }

    private void setupFilterToday() {
        // --- initialize date filter to today
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        after = cal.getTime();
        cal.add(Calendar.DATE, 1);
        before = cal.getTime();
    }

    /*
     * public String getFlowRefParameterName(int numIndex) { String name = null;
     * name = listGlobalFlowParam.get(numIndex).getName(); return name; }
     * 
     * public String getFlowParameterName(FlowWithParams flowWithParams, int
     * numIndex){ if(flowWithParams.getElement() !=null &&
     * !flowWithParams.getElement().isEmpty()){ return
     * flowWithParams.getElement().get(numIndex); } else{ return null; } }
     */
    public String getFlowParameterName(int numIndex, FlowWithParams f) {
        String name = listGlobalFlowParam.get(numIndex).getName();
        return name;
    }

    public String getShortName(FlowWithParams flowWithParams) {

        String shortName = flowWithParams.getIdpetals();

        if (shortName != null) {

            if (shortName.length() > 30) {
                shortName = shortName.substring(0, 27) + "...";
            }
        } else {

            shortName = " ";
        }

        return shortName;
    }

    public String getName(FlowWithParams flowWithParams) {

        String name = flowWithParams.getIdpetals();
        return name;

    }

    /*
     * public void resetFilter() { after = null; before = null; }
     */

    public void viewAllFlow() {
        after = null;
        before = null;
        listFlowWithParams = new ArrayList<FlowWithParams>();
        listFlowWithParams = flowRefManager.getFlowsWithParameters(listGlobalFlowParam,
                (short) type, after, before);
    }

    public void validateFilter() throws ValidationErrors {
        System.out.println("--> validate");
        Date now = new Date();
        ValidationErrors errors = new ValidationErrors();

        if (after != null && after.after(now)) {
            System.out.println("--> future");
            errors.addItemError("flows.after", new LocalizedValidationError(
                    "validation.date.future"));
        }

        if (before != null && after != null && after.after(before)) {
            System.out.println("--> negative range");
            errors.addItemError("flows.before", new LocalizedValidationError(
                    "validation.date.negative_range"));
        }

        if (errors.hasErrors()) {
            System.out.println("--> throw");
            throw errors;
        }
    }

    public void applyFilterByType() {
        listFlowWithParams = flowRefManager.getFlowsWithParameters(listGlobalFlowParam,
                (short) type, after, before);
    }

    public void refresh() {
        if (after == null && before == null) {
            viewAllFlow();
        } else {
            setupFilterToday();

            listFlowWithParams = flowRefManager.getFlowsWithParameters(listGlobalFlowParam,
                    (short) type, after, before);
        }
    }
    
    public void deleteOldFlows () throws Exception {
    	flowManager.removeOldFlow(type);
    	refresh();
    }
    
    public String referenceTimeVerification() {
    	FlowRef fR = flowRefManager.getFlowRef(type);
    	
    	int referenceTime = fR.getReferenceTime();
    	flowRefName = fR.getName();
    	if(referenceTime == 0){
    		return "zeroValue";
    	}
    	else{
    		return "otherValues";
    	}
    	
    }

    // ===============================================================
    // === setters/getters
    // ===============================================================
    public int[] getParamIndex() {
        return paramIndex;
    }

    public List<FlowWithParams> getFlowsWithParams() {
        return listFlowWithParams;
    }

    public Date getBefore() {
        return before;
    }

    public void setBefore(Date before) {
        this.before = before;
    }

    public Date getAfter() {
        return after;
    }

    public void setAfter(Date after) {
        this.after = after;
    }

    public static int[] getAllStatus() {
        return ALL_STATUS;
    }
    
   
    /**
	 * @return the flowRefName
	 */
	public String getFlowRefName() {
		return flowRefName;
	}

	/**
	 * @param flowRefName the flowRefName to set
	 */
	public void setFlowRefName(String flowRefName) {
		this.flowRefName = flowRefName;
	}

	/**
     * Convert a flow status into a ui status (in_progress = 2, success = 0,
     * failure = 1)
     * 
     * @param status
     * @return
     */
    public int getUiStatus(int status) {
        if (status == Flow.SUCCESS_STATUS)
            return 0;
        else if (status == Flow.IN_PROGRESS_STATUS)
            return 2;
        else
            return 1;
    }
}
