/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.admin;

import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupException;
import com.ebmwebsourcing.webcommons.user.api.to.RoleGroupTO;
import com.ebmwebsourcing.webcommons.user.api.to.UserTO;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.session.OpenSuitSession;

public class RoleBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private String id;
    private String name;
    private List<RoleGroupTO> roles = new ArrayList();
    private RoleGroupTO role;
    private List<UserTO> allUsers;
    private List<UserTO> listUsersTO = new ArrayList();
    private List<String> listRoles = new ArrayList();
    private final String[] allRoles = PetalsViewServiceFactory.getInstance().getRoleManager().getAllRoles();

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        String idRole = iRequest.getParameter("roleId");
        try {
            this.role = PetalsViewServiceFactory.getInstance().getRoleGroupManager().getRoleGroup(idRole);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.name = this.role.getName();
        this.id = idRole;
        this.listRoles = this.role.getListRoles();
        this.listUsersTO = this.role.getListUsers();
    }

    public void loadAllRoles() throws LocalizedError {
        try {
            this.roles = PetalsViewServiceFactory.getInstance().getRoleGroupManager().getAllRoleGroup();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadUsersNotInRole() throws LocalizedError {
        try {
            this.allUsers = PetalsViewServiceFactory.getInstance().getUserManager().getUserNotInRoleGroup(this.id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void create() throws IError {
        this.role = new RoleGroupTO();
        this.role.setName(this.name);
        this.role.setListRoles(this.listRoles);
        this.role.setListUsers(this.listUsersTO);
        try {
            this.id = PetalsViewServiceFactory.getInstance().getRoleGroupManager().createRoleGroup(this.role);
        }
        catch (RoleGroupException e) {
            NonLocalizedError error = new NonLocalizedError("Can't create role.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void save() throws IError {
        RoleGroupTO roleTmp = new RoleGroupTO();
        roleTmp.setId(this.id);
        roleTmp.setName(this.name);
        roleTmp.setListRoles(this.listRoles);
        if (this.listUsersTO != null) {
            roleTmp.setListUsers(this.listUsersTO);
        }
        try {
            this.id = PetalsViewServiceFactory.getInstance().getRoleGroupManager().updateRoleGroup(roleTmp);
        }
        catch (RoleGroupException e) {
            this.load(OpenSuitSession.getCurrentRequest());
            this.name = this.role.getName();
            NonLocalizedError error = new NonLocalizedError("Can't save role.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.load(OpenSuitSession.getCurrentRequest());
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void delete(HttpServletRequest iRequest) throws IError {
        String idRole = iRequest.getParameter("roleId");
        try {
            PetalsViewServiceFactory.getInstance().getRoleGroupManager().removeRoleGroup(idRole);
            this.loadAllRoles();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void refresh() throws LocalizedError {
        try {
            this.role = PetalsViewServiceFactory.getInstance().getRoleGroupManager().getRoleGroup(this.id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.name = this.role.getName();
        this.listRoles = this.role.getListRoles();
        this.listUsersTO = this.role.getListUsers();
    }

    public void clear() {
    }

    public void reset() {
    }

    public void removeUser(HttpServletRequest iRequest) throws IError {
        String idUser = iRequest.getParameter("userId");
        try {
            PetalsViewServiceFactory.getInstance().getRoleGroupManager().removeUser(idUser, this.id);
        }
        catch (RoleGroupException e) {
            NonLocalizedError error = new NonLocalizedError("Can't create role.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.refresh();
    }

    public void removeAllUsers() throws IError {
        for (UserTO us : this.listUsersTO) {
            String idUser = us.getId();
            try {
                PetalsViewServiceFactory.getInstance().getRoleGroupManager().removeUser(idUser, this.id);
            }
            catch (RoleGroupException e) {
                NonLocalizedError error = new NonLocalizedError("Can't create role.", e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            catch (Throwable e) {
                this.logger.error((Object)e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        this.refresh();
    }

    public void addUser(HttpServletRequest iRequest) throws IError {
        String idUser = iRequest.getParameter("userId");
        try {
            PetalsViewServiceFactory.getInstance().getRoleGroupManager().addUser(idUser, this.id);
        }
        catch (RoleGroupException e) {
            NonLocalizedError error = new NonLocalizedError("Can't create role.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadUsersNotInRole();
        this.refresh();
    }

    public void addAllUsers() throws IError {
        for (UserTO us : this.allUsers) {
            String idUser = us.getId();
            try {
                PetalsViewServiceFactory.getInstance().getRoleGroupManager().addUser(idUser, this.id);
            }
            catch (RoleGroupException e) {
                NonLocalizedError error = new NonLocalizedError("Can't create role.", e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            catch (Throwable e) {
                this.logger.error((Object)e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        this.refresh();
    }

    public boolean canDeleteOrUpadateRole(String roleName) {
        boolean verif = !roleName.equals("admin");
        return verif;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<RoleGroupTO> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleGroupTO> roles) {
        this.roles = roles;
    }

    public RoleGroupTO getRole() {
        return this.role;
    }

    public void setRole(RoleGroupTO role) {
        this.role = role;
    }

    public List<UserTO> getAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(List<UserTO> allUsers) {
        this.allUsers = allUsers;
    }

    public List<UserTO> getListUsersTO() {
        return this.listUsersTO;
    }

    public void setListUsersTO(List<UserTO> listUsersTO) {
        this.listUsersTO = listUsersTO;
    }

    public List<String> getListRoles() {
        return this.listRoles;
    }

    public void setListRoles(List<String> listRoles) {
        this.listRoles = listRoles;
    }

    public String[] getAllRoles() {
        return this.allRoles;
    }
}

