/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.referential;

import com.ebmwebsourcing.petalsview.gui.beans.referential.ReferentialBean;
import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class CreateFlowRef {
    private int type;
    private String stringType;
    private String name;
    private String idUnknowFlow;
    private boolean editType;
    private FlowRefManager flowRefManager;
    private FlowManager flowManager = PetalsViewServiceFactory.getInstance().getFlowManager();

    public CreateFlowRef() {
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
    }

    public void init(HttpServletRequest request) throws Exception {
        String id = request.getParameter("idFlow");
        if (id != null) {
            Flow flow = this.flowManager.load(id);
            this.idUnknowFlow = flow.getIdpetals();
            this.type = flow.getType();
            this.stringType = String.valueOf(this.type);
            this.editType = false;
        } else {
            this.idUnknowFlow = "null";
            this.editType = true;
            this.stringType = null;
        }
        this.name = null;
    }

    public String create() throws Exception {
        try {
            this.type = Integer.parseInt(this.stringType);
            this.flowRefManager.createFlowRef(this.type, this.name);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefException e) {
            NonLocalizedError error = new NonLocalizedError("create_flowref.constraint", null, (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        ReferentialBean.reload();
        return "success";
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdUnknowFlow() {
        return this.idUnknowFlow;
    }

    public String getStringType() {
        return this.stringType;
    }

    public void setStringType(String stringType) {
        this.stringType = stringType;
    }

    public boolean isEditType() {
        return this.editType;
    }

    public void setEditType(boolean editType) {
        this.editType = editType;
    }
}

