/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.referential;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.LocalizedError;

public class StepErrorRefDetails {
    private int errorCode;
    private String errorMessage;
    private FlowStepErrorRef stepErrorRef;
    private String stepRefId;
    private FlowStepRefManager flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();

    public FlowStepErrorRef getStepErrorRef() {
        return this.stepErrorRef;
    }

    public void setStepErrorRef(FlowStepErrorRef stepErrorRef) {
        this.stepErrorRef = stepErrorRef;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void load(HttpServletRequest request) throws Exception {
        String id = request.getParameter("id");
        this.init(request);
        this.loadStepErrorRef(id);
    }

    public void init(HttpServletRequest request) {
        this.stepRefId = request.getParameter("stepRefId");
    }

    private void loadStepErrorRef(String id) throws Exception {
        this.stepErrorRef = this.flowStepRefManager.loadStepErrorRef(id);
        this.reset();
    }

    public void reset() {
        this.errorCode = this.stepErrorRef.getErrorCode();
        this.errorMessage = this.stepErrorRef.getMessage();
    }

    public String create() throws LocalizedError, Exception {
        FlowStepErrorRef stepErrorRef = new FlowStepErrorRef();
        stepErrorRef.setErrorCode(this.errorCode);
        stepErrorRef.setMessage(this.errorMessage);
        stepErrorRef.setFlowstepref(this.flowStepRefManager.loadStepRef(this.stepRefId));
        try {
            this.flowStepRefManager.saveOrUpdateErrorRef(stepErrorRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowsteperrorref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefException e) {
            LocalizedError error = new LocalizedError("create_flowsteperrorref.constraint", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        return "success";
    }

    public String update() throws LocalizedError, Exception {
        this.stepErrorRef.setErrorCode(this.errorCode);
        this.stepErrorRef.setMessage(this.errorMessage);
        try {
            this.flowStepRefManager.saveOrUpdateErrorRef(this.stepErrorRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("update_flowsteperrorref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefException e) {
            LocalizedError error = new LocalizedError("update_flowsteperrorref.constraint", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        return "success";
    }
}

