/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.supervision;

import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowParamsDetails;
import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;

public class FlowDetails {
    private Flow flow;
    private List<FlowStep> steps;
    private FlowRef flowRef;
    private FlowManager flowManager;
    private FlowRefManager flowRefManager;
    private FlowStepManager flowStepManager;
    private FlowStepRefManager flowStepRefManager;
    private List<FlowParamsDetails> listFlowParamsDetails = new ArrayList();
    FlowStepRef flowStepRef = new FlowStepRef();

    public FlowDetails() {
        this.flowManager = PetalsViewServiceFactory.getInstance().getFlowManager();
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
        this.flowStepManager = PetalsViewServiceFactory.getInstance().getFlowStepManager();
        this.flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();
    }

    public void load(HttpServletRequest request) throws Exception {
        String id = request.getParameter("id");
        this.flow = this.flowManager.load(id);
        if (this.flow.getStatus() == null) {
            this.flow.setStatus(Integer.valueOf(-1));
        }
        this.steps = this.flowStepManager.loadSteps(id, this.flow.getType());
        this.listFlowParamsDetails = this.flowRefManager.getDetailFlowParameter((short)this.flow.getType(), id);
    }

    public void refresh() throws Exception {
        this.flow = this.flowManager.load(this.flow.getIdpetals());
        if (this.flow.getStatus() == null) {
            this.flow.setStatus(Integer.valueOf(-1));
        }
        this.steps = this.flowStepManager.loadSteps(this.flow.getIdpetals(), this.flow.getType());
        this.listFlowParamsDetails = this.flowRefManager.getDetailFlowParameter((short)this.flow.getType(), this.flow.getIdpetals());
    }

    public Flow getFlow() {
        return this.flow;
    }

    public Flow[] getFlows() {
        return new Flow[]{this.flow};
    }

    public List<FlowStep> getSteps() {
        return this.steps;
    }

    public FlowRef getFlowRef() {
        return this.flowRef;
    }

    public String getFlowType() {
        String result = "Undefined flow type";
        if (this.flowRef != null) {
            result = this.flowRef.getName();
        }
        return result;
    }

    public List<FlowParamsDetails> getListFlowParamsDetails() {
        return this.listFlowParamsDetails;
    }

    public String getShortStepName(FlowStep step) throws Exception {
        String result = "";
        this.flowStepRef = this.flowStepRefManager.loadStepRef(this.flow.getType(), step.getInterfaceName(), step.getServiceName());
        if (this.flowStepRef != null) {
            result = this.flowStepRef.getName();
            if (result.length() > 30) {
                result = result.substring(0, 27) + "...";
            }
        } else {
            result = step.getInterfaceName() + "/" + step.getServiceName();
            if (result.length() > 30) {
                String shortIntName = QName.valueOf(step.getInterfaceName()).getLocalPart().length() > 11 ? QName.valueOf(step.getInterfaceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(step.getInterfaceName()).getLocalPart();
                String shortServName = QName.valueOf(step.getServiceName()).getLocalPart().length() > 11 ? QName.valueOf(step.getServiceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(step.getServiceName()).getLocalPart();
                result = shortIntName + "/" + shortServName;
            }
        }
        return result;
    }

    public String getStepName(FlowStep step) {
        String result = "";
        result = this.flowStepRef != null ? this.flowStepRef.getName() : step.getInterfaceName() + "/" + step.getServiceName();
        return result;
    }

    public String getStepKey(FlowStep step) {
        return step.getInterfaceName() + "/" + step.getServiceName() + "/" + step.getEndpointName() + "/" + step.getMeUUID();
    }

    public int getUiStatus(int status) {
        if (status == 0) {
            return 0;
        }
        if (status == -1) {
            return 2;
        }
        return 1;
    }

    public String getStepMessage(FlowStep step) throws Exception {
        Object result = "No messages defined for this step";
        FlowStepRef flowStepRef = this.flowStepRefManager.loadStepRef(this.flow.getType(), step.getInterfaceName(), step.getServiceName());
        if (flowStepRef != null) {
            FlowStepErrorRef error;
            result = step.getStatus() == 0 ? flowStepRef.getSuccessMessage() : (step.getStatus() == -1 ? null : ((error = (FlowStepErrorRef)flowStepRef.getErrorMessages().get(step.getStatus())) == null ? (flowStepRef.getDefaultErrorMessage() != null ? flowStepRef.getDefaultErrorMessage() : "Error " + step.getStatus() + " (?)") : error.getMessage()));
        }
        return result;
    }
}

