package com.ebmwebsourcing.petalsview.gui.beans.referential;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

public class DataExporterBean {

	private final Logger logger = Logger.getLogger(this.getClass());

	private List<FlowRef> flowRefs;

	private String[] selection;

	private String fileName;

	private FlowRefManager flowRefManager;

	public DataExporterBean() {
		super();
		this.flowRefManager = PetalsViewServiceFactory.getInstance()
				.getFlowRefManager();
	}

	public void loadAll() {
		flowRefs = flowRefManager.loadAll();
	}

	public void download(HttpServletResponse response)
			throws ParserConfigurationException, JAXBException, IOException,
			LocalizedError {
//		response.setContentType("text/xml");
		response.setContentType("text/petlasviewexport");
		response.setCharacterEncoding("UTF-8");
		//response.setHeader("Cache-Control", "no-cache"); // HTTP 1.1
		//response.setHeader("Pragma", "no-cache"); // HTTP 1.0
		//response.setDateHeader("Expires", 0); // prevents caching at the proxy
		// server

		PrintWriter output = response.getWriter();

		try {
			PetalsViewServiceFactory.getInstance().getExporter()
					.exportReferential(output, selection);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw new LocalizedError("database_technical", new Object[] { e
					.getMessage() });
		}

		output.flush();
		output.close();
	}

	public List<FlowRef> getFlowRefs() {
		return flowRefs;
	}

	public void setFlowRefs(List<FlowRef> flowRefs) {
		this.flowRefs = flowRefs;
	}

	public String[] getSelection() {
		return selection;
	}

	public void setSelection(String[] selection) {
		this.selection = selection;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

}
