/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * StepErrorRefDetails.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.referential;

import javax.servlet.http.HttpServletRequest;

import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

/**
 * @author ofabre
 * 
 */
public class StepErrorRefDetails {

    private int errorCode;

    private String errorMessage;

    private FlowStepErrorRef stepErrorRef;

    private String stepRefId;

    // private FlowManager flowManager;
    //private FlowRefManager flowRefManager;
    private FlowStepRefManager flowStepRefManager;

    public StepErrorRefDetails() {
        super();
        // this.flowManager =
        // PetalsViewServiceFactory.getInstance().getFlowManager();
        this.flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();
    }

    public FlowStepErrorRef getStepErrorRef() {
        return stepErrorRef;
    }

    public void setStepErrorRef(FlowStepErrorRef stepErrorRef) {
        this.stepErrorRef = stepErrorRef;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void load(HttpServletRequest request) throws Exception {
       // long id = Long.parseLong(request.getParameter("id"));
        String id = request.getParameter("id");
        init(request);
        loadStepErrorRef(id);
    }

    public void init(HttpServletRequest request) {
        stepRefId = request.getParameter("stepRefId");
    }

    private void loadStepErrorRef(String id) throws Exception {
        stepErrorRef = flowStepRefManager.loadStepErrorRef(id);
        reset();
    }

    public void reset() {
        errorCode = stepErrorRef.getErrorCode();
        errorMessage = stepErrorRef.getMessage();
    }

    public String create() throws LocalizedError, Exception {
        FlowStepErrorRef stepErrorRef = new FlowStepErrorRef();
        stepErrorRef.setErrorCode(errorCode);
        stepErrorRef.setMessage(errorMessage);
        stepErrorRef.setFlowstepref(flowStepRefManager.loadStepRef(stepRefId));
        try {
        	flowStepRefManager.saveOrUpdateErrorRef(stepErrorRef);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowsteperrorref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        }catch (FlowRefException e){
            LocalizedError error = new LocalizedError("create_flowsteperrorref.constraint", e);
            error.setType(IError.FUNCTIONAL_ERROR);
            throw error;
    }

        return "success";
    }

    public String update() throws LocalizedError, Exception {
        stepErrorRef.setErrorCode(errorCode);
        stepErrorRef.setMessage(errorMessage);
        try {
        	flowStepRefManager.saveOrUpdateErrorRef(stepErrorRef);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("update_flowsteperrorref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        }catch (FlowRefException e){
        LocalizedError error = new LocalizedError("update_flowsteperrorref.constraint", e);
        error.setType(IError.FUNCTIONAL_ERROR);
        throw error;
}

        return "success";
    }

}
