/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.referential;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;

public class DataExporterBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private List<FlowRef> flowRefs;
    private String[] selection;
    private String fileName;
    private FlowRefManager flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();

    public void loadAll() {
        this.flowRefs = this.flowRefManager.loadAll();
    }

    public void download(HttpServletResponse response) throws ParserConfigurationException, JAXBException, IOException, LocalizedError {
        response.setContentType("text/petlasviewexport");
        response.setCharacterEncoding("UTF-8");
        PrintWriter output = response.getWriter();
        try {
            PetalsViewServiceFactory.getInstance().getExporter().exportReferential((Writer)output, this.selection);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        output.flush();
        output.close();
    }

    public List<FlowRef> getFlowRefs() {
        return this.flowRefs;
    }

    public void setFlowRefs(List<FlowRef> flowRefs) {
        this.flowRefs = flowRefs;
    }

    public String[] getSelection() {
        return this.selection;
    }

    public void setSelection(String[] selection) {
        this.selection = selection;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

