/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.referential;

import com.ebmwebsourcing.petalsview.gui.beans.referential.ReferentialBean;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.springframework.util.StringUtils;

public class DataLoaderBean {
    private Logger logger = Logger.getLogger(this.getClass());
    private String datasetLocation = null;

    public String loadDataset() throws LocalizedError, Exception {
        try {
            if (StringUtils.hasText((String)this.datasetLocation)) {
                PetalsViewServiceFactory.getInstance().getDataLoader().loadDataSet(this.datasetLocation);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError("Can't import Referential", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        ReferentialBean.reload();
        this.datasetLocation = null;
        return "success";
    }

    public String loadDataset(IFileUploadPart file) throws LocalizedError, Exception {
        try {
            PetalsViewServiceFactory.getInstance().getDataLoader().loadDataset(file.getFileInputStream());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            NonLocalizedError error = new NonLocalizedError("Can't import Referential", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        ReferentialBean.reload();
        this.datasetLocation = null;
        return "success";
    }

    public String submit() {
        return "success";
    }

    public String getDatasetLocation() {
        return this.datasetLocation;
    }

    public void setDatasetLocation(String datasetLocation) {
        this.datasetLocation = datasetLocation;
    }
}

