/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.referential;

import com.ebmwebsourcing.petalsview.gui.beans.referential.FlowReferential;
import com.ebmwebsourcing.petalsview.gui.beans.referential.ReferentialBean;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.StepParameter;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class FlowReferential {
    private FlowRef flowRef;
    private List<FlowStepRef> stepRefs;
    private String[] selectedSteps;
    private List<FlowStep> unknowsSteps;
    private FlowRefManager flowRefManager;
    private FlowStepManager flowStepManager = PetalsViewServiceFactory.getInstance().getFlowStepManager();
    private FlowStepRefManager flowStepRefManager;
    private boolean viewUnkownStep;
    private int type;
    private String idFlow;
    private String name;
    private String id;
    boolean editableCreate;
    boolean editableDelete;
    boolean backup = false;
    int referenceTime;
    String urlBackup;
    String fileName;
    int limitValue;

    public FlowReferential() {
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
        this.flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();
    }

    public void load(HttpServletRequest request) throws Exception, IError {
        this.type = Integer.parseInt(request.getParameter("type"));
        this.idFlow = request.getParameter("idFlow");
        this.loadFlowRef(this.type);
        this.loadStepRefs(this.type);
    }

    private void loadFlowRef(int type) {
        this.flowRef = this.flowRefManager.getFlowRef(type);
        type = this.flowRef.getType();
        this.name = this.flowRef.getName();
        this.id = this.flowRef.getId();
        this.referenceTime = this.flowRef.getReferenceTime();
        this.backup = this.flowRef.isSave();
        this.urlBackup = this.flowRef.getUrlBackup();
        this.fileName = this.flowRef.getFileName();
        this.limitValue = this.flowRef.getLimitValue();
        if (this.referenceTime == 0) {
            this.editableCreate = true;
            this.editableDelete = false;
        } else {
            this.editableCreate = false;
            this.editableDelete = true;
        }
    }

    private void loadStepRefs(int type) throws Exception, IError {
        this.stepRefs = this.flowStepRefManager.loadSteps(type);
        this.selectedSteps = new String[0];
        this.unknowsSteps = this.flowStepManager.loadSteps(this.idFlow, type);
        if (this.unknowsSteps != null && !this.unknowsSteps.isEmpty()) {
            this.removeStepWithReferential(type);
        } else {
            this.viewUnkownStep = false;
        }
    }

    public void save() throws Exception {
        try {
            FlowRef flowRef = new FlowRef();
            flowRef.setId(this.id);
            flowRef.setName(this.name);
            flowRef.setType(this.type);
            this.flowRefManager.update(flowRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefException e) {
            NonLocalizedError error = new NonLocalizedError("create_flowref.constraint", null, (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        ReferentialBean.reload();
    }

    public void removeStepRefs() throws Exception, IError {
        this.flowStepRefManager.removeStepRefs(this.selectedSteps);
        this.loadStepRefs(this.flowRef.getType());
    }

    public String getStepName(FlowStep flowStep) {
        String result = "";
        result = flowStep.getInterfaceName() + "/" + flowStep.getServiceName();
        return result;
    }

    public String getShortStepName(FlowStep flowStep) {
        String result = "";
        result = flowStep.getInterfaceName() + "/" + flowStep.getServiceName();
        if (result.length() > 30) {
            String shortIntName = QName.valueOf(flowStep.getInterfaceName()).getLocalPart().length() > 11 ? QName.valueOf(flowStep.getInterfaceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(flowStep.getInterfaceName()).getLocalPart();
            String shortServName = QName.valueOf(flowStep.getServiceName()).getLocalPart().length() > 11 ? QName.valueOf(flowStep.getServiceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(flowStep.getServiceName()).getLocalPart();
            result = shortIntName + "/" + shortServName;
        }
        return result;
    }

    private void removeStepWithReferential(int type) throws IError {
        int i = 0;
        ArrayList<FlowStep> flowStepsTmp = new ArrayList<FlowStep>();
        FlowStepRef flowStepRefTmp = new FlowStepRef();
        for (FlowStep fS : this.unknowsSteps) {
            flowStepsTmp.add(fS);
        }
        for (i = 0; i < this.unknowsSteps.size(); ++i) {
            try {
                flowStepRefTmp = this.flowStepRefManager.loadStepRef(((FlowStep)this.unknowsSteps.get(i)).getFlow().getType(), ((FlowStep)this.unknowsSteps.get(i)).getInterfaceName(), ((FlowStep)this.unknowsSteps.get(i)).getServiceName());
            }
            catch (FlowRefException e) {
                NonLocalizedError error = new NonLocalizedError("Can't remove step referential.", e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            if (flowStepRefTmp == null) continue;
            FlowStep fS = (FlowStep)this.unknowsSteps.get(i);
            flowStepsTmp.remove(fS);
        }
        this.unknowsSteps = flowStepsTmp;
        this.viewUnkownStep = this.unknowsSteps.size() != 0;
    }

    public void reset() {
    }

    public void createPurge() throws Exception {
        this.editableCreate = false;
        this.editableDelete = true;
        try {
            FlowRef flowRef = new FlowRef();
            flowRef.setId(this.id);
            flowRef.setName(this.name);
            flowRef.setType(this.type);
            flowRef.setReferenceTime(Integer.valueOf(this.referenceTime));
            flowRef.setFileName(this.fileName);
            flowRef.setUrlBackup(this.urlBackup);
            flowRef.setSave(this.backup);
            flowRef.setLimitValue(Integer.valueOf(this.limitValue));
            this.flowRefManager.update(flowRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefException e) {
            NonLocalizedError error = new NonLocalizedError("create_flowref.constraint", null, (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public void deletePurge() throws Exception {
        try {
            FlowRef flowRef = new FlowRef();
            flowRef.setId(this.id);
            flowRef.setName(this.name);
            flowRef.setType(this.type);
            flowRef.setReferenceTime(Integer.valueOf(0));
            flowRef.setFileName(null);
            flowRef.setUrlBackup(null);
            flowRef.setSave(false);
            flowRef.setLimitValue(Integer.valueOf(0));
            this.flowRefManager.update(flowRef);
        }
        catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowref.constraint", (Throwable)e);
            le.setType((short)0);
            throw le;
        }
        catch (HibernateException e) {
            throw new LocalizedError("database", (Throwable)e);
        }
        catch (FlowRefException e) {
            NonLocalizedError error = new NonLocalizedError("create_flowref.constraint", null, (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.referenceTime = 0;
        this.backup = false;
        this.urlBackup = null;
        this.fileName = null;
        this.editableDelete = false;
        this.editableCreate = true;
    }

    public FlowRef getFlowRef() {
        return this.flowRef;
    }

    public List<FlowStepRef> getStepRefs() {
        return this.stepRefs;
    }

    public String[] getSelectedSteps() {
        return this.selectedSteps;
    }

    public void setSelectedSteps(String[] selectedSteps) {
        this.selectedSteps = selectedSteps;
    }

    public String buildErrorMessagesHtml(FlowStepRef step) {
        Map errorMessages = step.getErrorMessages();
        String defaultErrorMessage = step.getDefaultErrorMessage();
        if (!(defaultErrorMessage != null && !"".equals(defaultErrorMessage) || errorMessages != null && errorMessages.size() != 0)) {
            return null;
        }
        Collection errors = errorMessages.values();
        StringBuffer sb = new StringBuffer();
        sb.append("\\html\\");
        sb.append("<ul class=list>\n");
        for (FlowStepErrorRef error : errors) {
            sb.append("<li>");
            sb.append(String.valueOf(error.getErrorCode()));
            sb.append(": ");
            sb.append(error.getMessage());
            sb.append("</li>\n");
        }
        if (defaultErrorMessage != null || !"".equals(defaultErrorMessage)) {
            sb.append("<li>");
            sb.append("default");
            sb.append(": ");
            sb.append(defaultErrorMessage);
            sb.append("</li>\n");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public String getShortStepKey(FlowStepRef step) {
        String result = step.getInterfaceName() + "/" + step.getServiceName();
        if (result.length() > 50) {
            String shortIntName = QName.valueOf(step.getInterfaceName()).getLocalPart().length() > 21 ? QName.valueOf(step.getInterfaceName()).getLocalPart().substring(0, 20) + "..." : QName.valueOf(step.getInterfaceName()).getLocalPart();
            String shortServName = QName.valueOf(step.getServiceName()).getLocalPart().length() > 21 ? QName.valueOf(step.getServiceName()).getLocalPart().substring(0, 20) + "..." : QName.valueOf(step.getServiceName()).getLocalPart();
            result = shortIntName + "/" + shortServName;
        }
        return result;
    }

    public String getStepName(FlowStepRef step) {
        return step.getName();
    }

    public String getShortStepName(FlowStepRef step) {
        String result = "";
        result = step.getName().length() > 50 ? step.getName().substring(0, 46) + "..." : step.getName();
        return result;
    }

    public String getStepKey(FlowStepRef step) {
        return step.getInterfaceName() + "/" + step.getServiceName();
    }

    public List<FlowRefParameter> getFlowParameters() {
        ArrayList<FlowRefParameter> result = new ArrayList<FlowRefParameter>();
        if (this.stepRefs != null) {
            for (FlowStepRef stepRef : this.stepRefs) {
                if (stepRef.getParameterNames() == null) continue;
                for (StepParameter stepParameter : stepRef.getParameterNames()) {
                    if (!stepParameter.isGlobal()) continue;
                    result.add(new FlowRefParameter(this, stepParameter, stepRef));
                }
            }
        }
        return result;
    }

    public List<FlowStep> getUnknowsSteps() {
        return this.unknowsSteps;
    }

    public void setUnknowsSteps(List<FlowStep> unknowsSteps) {
        this.unknowsSteps = unknowsSteps;
    }

    public boolean isViewUnkownStep() {
        return this.viewUnkownStep;
    }

    public void setViewUnkownStep(boolean viewUnkownStep) {
        this.viewUnkownStep = viewUnkownStep;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getIdFlow() {
        return this.idFlow;
    }

    public void setIdFlow(String idFlow) {
        this.idFlow = idFlow;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isEditableCreate() {
        return this.editableCreate;
    }

    public void setEditableCreate(boolean editableCreate) {
        this.editableCreate = editableCreate;
    }

    public boolean isEditableDelete() {
        return this.editableDelete;
    }

    public void setEditableDelete(boolean editableDelete) {
        this.editableDelete = editableDelete;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public int getReferenceTime() {
        return this.referenceTime;
    }

    public void setReferenceTime(int referenceTime) {
        this.referenceTime = referenceTime;
    }

    public String getUrlBackup() {
        return this.urlBackup;
    }

    public void setUrlBackup(String urlBackup) {
        this.urlBackup = urlBackup;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getLimitValue() {
        return this.limitValue;
    }

    public void setLimitValue(int limitValue) {
        this.limitValue = limitValue;
    }
}

