/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.supervision;

import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowWithParams;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.GlobalFlowParam;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class ListOfFlowWithParams {
    private static int[] ALL_STATUS = new int[]{0, 1, 2};
    private String flowRefName;
    private int type = -1;
    private int[] paramIndex;
    private Date before;
    private Date after;
    private FlowRefManager flowRefManager;
    private FlowManager flowManager;
    private List<GlobalFlowParam> listGlobalFlowParam = new ArrayList();
    private List<FlowWithParams> listFlowWithParams = new ArrayList();

    public ListOfFlowWithParams() {
        this.flowManager = PetalsViewServiceFactory.getInstance().getFlowManager();
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
    }

    public void loadByType(HttpServletRequest request) {
        this.type = Integer.parseInt(request.getParameter("type"));
        this.setupFilterToday();
        this.listGlobalFlowParam = this.flowRefManager.getGlobalFlowParameters((short)this.type);
        this.paramIndex = new int[this.listGlobalFlowParam.size()];
        this.listFlowWithParams = this.flowRefManager.getFlowsWithParameters(this.listGlobalFlowParam, (short)this.type, this.after, this.before);
        for (int i = 0; i < this.paramIndex.length; ++i) {
            this.paramIndex[i] = i;
        }
    }

    private void setupFilterToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.after = cal.getTime();
        cal.add(5, 1);
        this.before = cal.getTime();
    }

    public String getFlowParameterName(int numIndex, FlowWithParams f) {
        String name = ((GlobalFlowParam)this.listGlobalFlowParam.get(numIndex)).getName();
        return name;
    }

    public String getShortName(FlowWithParams flowWithParams) {
        String shortName = flowWithParams.getIdpetals();
        if (shortName != null) {
            if (shortName.length() > 30) {
                shortName = shortName.substring(0, 27) + "...";
            }
        } else {
            shortName = " ";
        }
        return shortName;
    }

    public String getName(FlowWithParams flowWithParams) {
        String name = flowWithParams.getIdpetals();
        return name;
    }

    public void viewAllFlow() {
        this.after = null;
        this.before = null;
        this.listFlowWithParams = new ArrayList();
        this.listFlowWithParams = this.flowRefManager.getFlowsWithParameters(this.listGlobalFlowParam, (short)this.type, this.after, this.before);
    }

    public void validateFilter() throws ValidationErrors {
        System.out.println("--> validate");
        Date now = new Date();
        ValidationErrors errors = new ValidationErrors();
        if (this.after != null && this.after.after(now)) {
            System.out.println("--> future");
            errors.addItemError("flows.after", (ValidationError)new LocalizedValidationError("validation.date.future"));
        }
        if (this.before != null && this.after != null && this.after.after(this.before)) {
            System.out.println("--> negative range");
            errors.addItemError("flows.before", (ValidationError)new LocalizedValidationError("validation.date.negative_range"));
        }
        if (errors.hasErrors()) {
            System.out.println("--> throw");
            throw errors;
        }
    }

    public void applyFilterByType() {
        this.listFlowWithParams = this.flowRefManager.getFlowsWithParameters(this.listGlobalFlowParam, (short)this.type, this.after, this.before);
    }

    public void refresh() {
        if (this.after == null && this.before == null) {
            this.viewAllFlow();
        } else {
            this.setupFilterToday();
            this.listFlowWithParams = this.flowRefManager.getFlowsWithParameters(this.listGlobalFlowParam, (short)this.type, this.after, this.before);
        }
    }

    public void deleteOldFlows() throws Exception {
        this.flowManager.removeOldFlow(this.type);
        this.refresh();
    }

    public String referenceTimeVerification() {
        FlowRef fR = this.flowRefManager.getFlowRef(this.type);
        int referenceTime = fR.getReferenceTime();
        this.flowRefName = fR.getName();
        if (!fR.isSave() && referenceTime == 0) {
            return "booleanSaveFalseWithoutReferenceTime";
        }
        if (!fR.isSave() && referenceTime != 0) {
            return "booleanSaveFalse";
        }
        if (referenceTime == 0) {
            return "zeroValueReferenceTime";
        }
        if (fR.getLimitValue() == 0) {
            return "zeroValueLimit";
        }
        return "otherValues";
    }

    public int[] getParamIndex() {
        return this.paramIndex;
    }

    public List<FlowWithParams> getFlowsWithParams() {
        return this.listFlowWithParams;
    }

    public Date getBefore() {
        return this.before;
    }

    public void setBefore(Date before) {
        this.before = before;
    }

    public Date getAfter() {
        return this.after;
    }

    public void setAfter(Date after) {
        this.after = after;
    }

    public static int[] getAllStatus() {
        return ALL_STATUS;
    }

    public String getFlowRefName() {
        return this.flowRefName;
    }

    public void setFlowRefName(String flowRefName) {
        this.flowRefName = flowRefName;
    }

    public int getUiStatus(int status) {
        if (status == 0) {
            return 0;
        }
        if (status == -1) {
            return 2;
        }
        return 1;
    }
}

