/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.supervision;

import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.StepParameter;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;

public class StepDetails {
    private FlowStep flowStep;
    private FlowStepRef flowStepRef;
    private int[] paramIndex;
    private FlowStepManager flowStepManager = PetalsViewServiceFactory.getInstance().getFlowStepManager();
    private FlowStepRefManager flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();

    public void load(HttpServletRequest request) throws Exception {
        String id = request.getParameter("id");
        this.flowStep = this.flowStepManager.loadFlowStep(id);
        List listParam = this.flowStep.getParameters();
        this.flowStepRef = this.flowStepRefManager.loadStepRef(this.flowStep.getFlow().getType(), this.flowStep.getInterfaceName(), this.flowStep.getServiceName());
        if (this.flowStepRef != null) {
            this.paramIndex = new int[this.flowStepRef.getParameterNames().size()];
            for (int i = 0; i < this.paramIndex.length; ++i) {
                this.paramIndex[i] = i;
            }
        }
        this.getListParam(listParam);
    }

    public void getListParam(List<String> listParam) {
        if (this.paramIndex != null) {
            if (listParam.isEmpty()) {
                for (int i = 0; i < this.paramIndex.length; ++i) {
                    listParam.add("");
                }
            }
            if (listParam.size() < this.paramIndex.length) {
                while (listParam.size() < this.paramIndex.length) {
                    listParam.add(" ");
                }
            }
        } else if (listParam.isEmpty()) {
            listParam.add("");
        } else {
            this.paramIndex = new int[listParam.size()];
            for (int i = 0; i < this.paramIndex.length; ++i) {
                this.paramIndex[i] = i;
            }
            ArrayList<StepParameter> listStepParam = new ArrayList<StepParameter>();
            for (int j = 0; j < this.paramIndex.length; ++j) {
                StepParameter stepParam = new StepParameter();
                stepParam.setName("Unkown");
                listStepParam.add(stepParam);
            }
            this.flowStepRef = new FlowStepRef();
            this.flowStepRef.setParameterNames(listStepParam);
        }
    }

    public FlowStep getFlowStep() {
        return this.flowStep;
    }

    public FlowStep[] getFlowSteps() {
        return new FlowStep[]{this.flowStep};
    }

    public FlowStepRef getFlowStepRef() {
        return this.flowStepRef;
    }

    public int[] getParamIndex() {
        return this.paramIndex;
    }

    public String getStepName() {
        String result = this.flowStep.getInterfaceName() + "/" + this.flowStep.getServiceName();
        if (this.flowStepRef != null) {
            result = this.flowStepRef.getName();
        }
        return result;
    }

    public String getShortStepName() {
        String result = "";
        if (this.flowStepRef != null) {
            result = this.flowStepRef.getName();
            if (result != null) {
                if (result.length() > 30) {
                    result = result.substring(0, 27) + "...";
                }
            } else {
                result = this.flowStep.getInterfaceName() + "/" + this.flowStep.getServiceName();
                if (result.length() > 30) {
                    String shortIntName = QName.valueOf(this.flowStep.getInterfaceName()).getLocalPart().length() > 11 ? QName.valueOf(this.flowStep.getInterfaceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(this.flowStep.getInterfaceName()).getLocalPart();
                    String shortServName = QName.valueOf(this.flowStep.getServiceName()).getLocalPart().length() > 11 ? QName.valueOf(this.flowStep.getServiceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(this.flowStep.getServiceName()).getLocalPart();
                    result = shortIntName + "/" + shortServName;
                }
            }
        } else {
            result = this.flowStep.getInterfaceName() + "/" + this.flowStep.getServiceName();
            if (result.length() > 30) {
                String shortIntName = QName.valueOf(this.flowStep.getInterfaceName()).getLocalPart().length() > 11 ? QName.valueOf(this.flowStep.getInterfaceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(this.flowStep.getInterfaceName()).getLocalPart();
                String shortServName = QName.valueOf(this.flowStep.getServiceName()).getLocalPart().length() > 11 ? QName.valueOf(this.flowStep.getServiceName()).getLocalPart().substring(0, 10) + "..." : QName.valueOf(this.flowStep.getServiceName()).getLocalPart();
                result = shortIntName + "/" + shortServName;
            }
        }
        return result;
    }

    public String getStepKey() {
        return this.flowStep.getInterfaceName() + "/" + this.flowStep.getServiceName() + "/" + this.flowStep.getEndpointName() + "/" + this.flowStep.getMeUUID();
    }

    public int getUiStatus(int status) {
        if (status == 0) {
            return 0;
        }
        if (status == -1) {
            return 2;
        }
        return 1;
    }

    public String getStepMessage() {
        if (this.flowStep.getStatus() == 0) {
            return this.flowStepRef.getSuccessMessage();
        }
        if (this.flowStep.getStatus() == -1) {
            return null;
        }
        FlowStepErrorRef error = (FlowStepErrorRef)this.flowStepRef.getErrorMessages().get(this.flowStep.getStatus());
        if (error == null) {
            return this.flowStepRef.getDefaultErrorMessage() != null ? this.flowStepRef.getDefaultErrorMessage() : "Error " + this.flowStep.getStatus() + " (?)";
        }
        return error.getMessage();
    }
}

