/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.util;

import java.io.IOException;
import java.util.Properties;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.security.cas.userdetails.AbstractCasAssertionUserDetailsService;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class FullAccessRightsUserDetailsService
extends AbstractCasAssertionUserDetailsService {
    private static final String NON_EXISTENT_PASSWORD_VALUE = "NO_PASSWORD";
    private Resource rolesResource;

    public UserDetails loadUserDetails(Assertion assertion) throws UsernameNotFoundException {
        try {
            Properties rolesProps = PropertiesLoaderUtils.loadProperties((Resource)this.rolesResource);
            Object[] roles = rolesProps.keySet().toArray(new Object[0]);
            GrantedAuthority[] arrayAuths = new GrantedAuthority[roles.length + 1];
            arrayAuths[0] = new GrantedAuthorityImpl("ROLE_AUTH");
            for (int j = 1; j < roles.length + 1; ++j) {
                arrayAuths[j] = new GrantedAuthorityImpl("ROLE_" + roles[j - 1]);
            }
            return new User(assertion.getPrincipal().getName(), NON_EXISTENT_PASSWORD_VALUE, true, true, true, true, arrayAuths);
        }
        catch (IOException e) {
            throw new UsernameNotFoundException("roles not found in config files.", (Throwable)e);
        }
    }

    public void setRolesResource(Resource rolesResource) {
        this.rolesResource = rolesResource;
    }
}

