/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.di.api;

/**
 *  Participant bands can be depicted in 3 ways:
 *	
 *	1. a top band is rectangular with rounded corners at the top
 *	2. a middle band is rectangular
 *	3. a bottom band is rectangular with rounded corners at the bottom
 *
 *	Participant bands can be depicted in 2 shadings:
 *	
 *	1. initiating (the band should not be shaded)
 *	2. non_initiating (the band should be shaded)
 *
 * @author nfleury
 *
 */
public enum ParticipantBandKind {

	top_initiating,
	middle_initiating,
	bottom_initiating,
	top_non_initiating,
	middle_non_initiating,
	bottom_non_initiating

}
