/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.di.impl;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.ILabel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.impl.Plane;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HasModelManager;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;
import com.ebmwebsourcing.petalsbpm.business.domain.di.api.IBPMNPlane;

public class BPMNPlane extends Plane implements IBPMNPlane{
	

	public BPMNPlane(){
		super();
	}
	
	public void setModelElement(BaseElementBean modelElement) {
		super.setModelElement(modelElement);
	}
	

	
	@Override
	public BaseElementBean getModelElement() {
		return (BaseElementBean) super.getModelElement();
	}
	
	
	public IDiagramElement getDiagramElementById(String id){
		if(this.getOwnedElements()!=null){
			for(IDiagramElement de : this.getOwnedElements()){
				if(de.getId().equals(id)){
					return de;
				}
			}
		}
		return null;
	}
	
	
	public Set<BPMNLabel> getAllLabels(){
		HashSet<BPMNLabel> result = new HashSet<BPMNLabel>();
		
		if(this.getOwnedElements()!=null){
			for(IDiagramElement de : this.getOwnedElements()){
				if(de instanceof BPMNShape){
					if(((BPMNShape)de).getOwnedLabels()!=null){
						for(ILabel l : ((BPMNShape)de).getOwnedLabels()){
							result.add((BPMNLabel) l);
						}
					}
				}
				else if(de instanceof BPMNEdge){
					if(((BPMNEdge)de).getOwnedLabels()!=null){
						for(ILabel l : ((BPMNEdge)de).getOwnedLabels()){
							result.add((BPMNLabel) l);
						}
					}
				}
			}
		}
		
		return result;
	}
	
	
	@Override 
	public HasModelManager getClone() {
		BPMNPlane p = new BPMNPlane();
		
		p.setModelElement(this.getModelElement());
		if(this.getOwnedElements()!=null){
			LinkedHashSet<IDiagramElement> elts = new LinkedHashSet<IDiagramElement>();
			for(IDiagramElement de : this.getOwnedElements()){
				elts.add((IDiagramElement) de.getClone());
			}
			p.setOwnedElements(elts);
			
			
			for(IDiagramElement de : this.getOwnedElements()){
				if(de instanceof BPMNEdge){
					BPMNEdge edge = (BPMNEdge) de;
					
					BPMNEdge e = (BPMNEdge) p.getDiagramElementById(de.getId());
					if(edge.getSource()!=null){
						e.setSource(p.getDiagramElementById(edge.getSource().getId()));
					}
					if(edge.getTarget()!=null){
						e.setTarget(p.getDiagramElementById(edge.getTarget().getId()));
					}
				}
				else if(de instanceof BPMNShape){
					BPMNShape shape = (BPMNShape) de;
					if(shape.getChoreographyActivityShape()!=null){
						BPMNShape s = (BPMNShape) p.getDiagramElementById(de.getId());
						s.setChoreographyActivityShape((BPMNShape) p.getDiagramElementById(shape.getChoreographyActivityShape().getId()));
					}
				}
			}
		}
		
		return p;
	}
}
