/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.business.domain.di.api;



import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.ILabeledShape;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;

/**
 * All BPMNShape elements are owned directly by a BPMNPlane (that is the root element in a BPMNDiagram), i.e., shapes
 * are not nested within each other in the BPMN DI model although they may appear that way when depicted. The bounds
 * of a BPMNShape are always relative to that plane's origin point and are REQUIRED to be positive coordinates. Note that
 * the bounds’ x and y coordinates are the position of the upper left corner of the shape (relative to the upper left corner of
 * the plane).
 * 
 * @author nfleury
 *
 */
public interface IBPMNShape extends ILabeledShape{

	IBaseElementBean getModelElement();
	
	/**
	 * Should be used only for Pools and Lanes. It determines if it should be depicted horizontally
	 * (true) or vertically (false).
	 * @return
	 */
	boolean isHorizontal();
	
	/**
	 *  Should be used only for SubProcess, AdHocSubProcess, Transaction, SubChoreographies ,
	 *	CallActivities and CallChoreographies. It determines if it should be depicted expanded (true) or collapsed (false).
	 *  @return
	 */
	boolean isExpanded();
	
	/**
	 * Should be used only for Exclusive Gateway. It determines if the marker should be depicted on
	 * the shape (true) or not (false).
	 * @return
	 */
	boolean isMarkerVisible();
	
	/**
	 * Should only be used for Participant Bands. If this attribute is present, it means that the
	 * participant should be depicted as a Participant Band instead of as a Pool.
	 * @return
	 */
	ParticipantBandKind getParticipantBandKind();
	
	/**
	 * Should only be used for Participant Bands. It determines if an envelope decorator should be
	 * depicted linked to the Participant Band.
	 * @return
	 */
	boolean isMessageVisible();
	
	/**
	 * Should only be used for Participant Bands. It is REQUIRED for a BPMNShape depicting a
	 * Participant Band. This is REQUIRED in order to relate the Participant Band to the BPMNShape depicting the
	 * Choreography Activity that this Participant Band is related to.
	 * @return
	 */
	IBPMNShape getChoreographyActivityShape();
	
}
