/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.common;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors.SequenceFlowType;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.ActivityEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.ExclusiveGatewayEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.SequenceFlowEditorModel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.process.gateway.ISequenceFlowBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.activity.ActivityBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.gateway.ExclusiveGatewayBean;

public class DefaultSequenceFlowState implements IDiagramElementGraphicState {
	
	private ISequenceFlowBean defaultSequenceFlow;
	
	private ISequenceFlowBean previousDefaultSequenceFlow;
	
	@Override
	public void changeGraphicState(IDiagramElementView diElementGraphic) {
		
		IConnectableElement connectable = (IConnectableElement) diElementGraphic;
		
		HashSet<IConnector> outgoingSequenceFlows = getOutgoingSequenceFlows(connectable);
		
		if (outgoingSequenceFlows.size()>1){
		
			for(IConnector c:outgoingSequenceFlows){

					SequenceFlow seqFlow = (SequenceFlow) c;
					
					if (seqFlow.getDiagramElement().getModelElement()==defaultSequenceFlow){
						
						seqFlow.setType(SequenceFlowType.DEFAULT);
						
					}else if (previousDefaultSequenceFlow!=null && seqFlow.getDiagramElement().getModelElement()==previousDefaultSequenceFlow){
						
						SequenceFlowEditorModel model = (SequenceFlowEditorModel) seqFlow.getEditorModel();
						
						if (model.getConditionnalExpression()!=null){
							
							if (model.getConditionnalExpression().equals("")==false) seqFlow.setType(SequenceFlowType.CONDITIONAL); 
							
						}else{
							seqFlow.setType(SequenceFlowType.NONE);						
						}
						
					}

				
			}
		
		}	
		
		previousDefaultSequenceFlow = defaultSequenceFlow;
		
	}
	
	
	private HashSet<IConnector> getOutgoingSequenceFlows(IConnectableElement connectable){
		
		HashSet<IConnector> result = new HashSet<IConnector>();
		
		for(IConnector connector:connectable.getOutgoingConnectors()){
			
			if (connector instanceof SequenceFlow){
				
				result.add(connector);
				
			}
			
		}
		
		
		return result;
	}
	
	
	@Override
	public boolean condition(IDiagramElement diElement,
			IEditorModel modelElement) {
		
		
		
		if (diElement.getModelElement() instanceof ActivityBean){
			
			ActivityEditorModel model = (ActivityEditorModel) modelElement;

			if (model.getDefaultSequenceFlow()!=null){
				
				this.defaultSequenceFlow = model.getDefaultSequenceFlow();
				
				return true;
			}
			
		}else if (diElement.getModelElement() instanceof ExclusiveGatewayBean) {
			
			ExclusiveGatewayEditorModel model = (ExclusiveGatewayEditorModel) modelElement; 
		
			if (model.getDefaultSequenceFlow()!=null){
				
				this.defaultSequenceFlow = model.getDefaultSequenceFlow();
				
				return true;
			}
		
		}

		

		
		return false;
	}
	
	
	
	
}