/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.data;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.DataInputBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.DataObjectBean;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.process.data.DataOutputBean;
import com.google.gwt.user.client.DOM;

public class DataFactory implements IDiagramElementGraphicFactory {
	
	private ProcessPanel definitionPanel;
	
	public DataFactory(ProcessPanel definitionPanel) {
		this.definitionPanel = definitionPanel;
	}
	
	
	public Data getData(IHasDragProxy bpmndragproxydata){
		
		if (bpmndragproxydata.getIUIElementType()==DataObject.class){
			return createDataObject();
		}else if (bpmndragproxydata.getIUIElementType()==DataInput.class){
			return createDataInput();
		}else if (bpmndragproxydata.getIUIElementType()==DataOutput.class){
			return createDataOutput();
		}
		
		
		return null;
	}
	
	public DataObject createDataObject(){
		
		String id = DOM.createUniqueId();
		
		DataObject dataObject = new DataObject(definitionPanel, id);
		
		dataObject.getDiagramElement().setModelElement(new DataObjectBean(id));
		
		return dataObject;
	}

	public DataInput createDataInput(){
		
		String id = DOM.createUniqueId();
		
		DataInput dataInput = new DataInput(definitionPanel, id);
		
		dataInput.getDiagramElement().setModelElement(new DataInputBean(id));
		
		return dataInput;
	}
	
	public DataOutput createDataOutput(){
		
		String id = DOM.createUniqueId();
		
		DataOutput dataOutput = new DataOutput(definitionPanel, id);
		
		dataOutput.getDiagramElement().setModelElement(new DataOutputBean(id));
		
		return dataOutput;
	}
	
	@Override
	public IDiagramElementView getElement(
			Class<? extends IDiagramElementView> elementType) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IDiagramElementView getElementByDiagramElementModel(
			IDiagramElement diagramElement) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IUIElement getElement(IHasDragProxy draggableProxyData) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IUIElement getElement(Class<? extends IUIElement> elementType) {
		// TODO Auto-generated method stub
		return null;
	}

}
