/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.modeleditor.template;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.IBPMNElement;
import com.google.gwt.user.client.ui.Widget;

public abstract class CommonFormTemplate extends AbstractTemplate {

	public CommonFormTemplate(IBPMNElement bpmnElement) {
		super(bpmnElement);
	}
	
	public CommonFormTemplate(IDiagramView bpmnDiagram){
		super(bpmnDiagram);
	}

	@Override
	protected List<LabelWidgetPair> getPairs() {
		ArrayList<LabelWidgetPair> result = new ArrayList<LabelWidgetPair>();	
		
		Widget name 			= (Widget) this.getUIField("name"); 
		Widget documentation 	=  (Widget) this.getUIField("documentation");
		
		if (name !=null) 			result.add(new LabelWidgetPair("Name", name));
		if (documentation !=null) 	result.add(new LabelWidgetPair("Documentation",documentation)); 
		
		
		return result;
	}



}
