/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.bpmndiagram.collaboration;

import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasygraph.api.IGraph;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectable;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElementDefaulHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IMagnet;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IConnectableHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizable;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.ConnectableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu.DragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.DefaultBoundsUpdateHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.ResizableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeStopEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.AbstractUITemplate;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.ProcessPanel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.ContextualMenuHandler;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.common.connector.MagnetElement;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors.MessageFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.connectors.SequenceFlow;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.dragproxy.impl.connectors.MessageFlowMenuDragProxy;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.editormodels.PoolEditorModel;
import com.ebmwebsourcing.petalsbpm.bpmndiagram.modeleditor.template.PoolFormTemplate;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;

public class CollapsedPool extends Swimlane implements IHasDragProxyContextualMenu, IConnectable,IResizable,ResizeHandler{

	private HashSet<IConnector> incommingConnectors;
	private HashSet<IConnector> outgoingConnectors;
	private HashSet<IMagnet>	magnets;
	

	private MagnetElement topLeftM;
	private MagnetElement topMiddleM;
	private MagnetElement topRightM;
	private MagnetElement leftM;
	private MagnetElement rightM;
	private MagnetElement bottomLeftM;
	private MagnetElement bottomRightM;
	private MagnetElement bottomMiddleM;
	
	private Rectangle boundary;
	private ConnectableElementDefaultHandlers defaultHandlers;
	
	private PoolSyntaxModelBinder poolSyntaxBinder;
	
	private ResizableElementDefaultHandlers resizableDefaultHanders;
	

	
	public CollapsedPool(ProcessPanel definitionPanel,
			String id) {
		super(definitionPanel, id);


		this.incommingConnectors = new HashSet<IConnector>();
		this.outgoingConnectors  = new HashSet<IConnector>();
		this.magnets			 = new HashSet<IMagnet>();
		
		this.resizableDefaultHanders = new ResizableElementDefaultHandlers(this);
		this.resizableDefaultHanders.attachDefaultHandlers();
		
		DefaultBoundsUpdateHandlers dbuh = new DefaultBoundsUpdateHandlers(this);
		dbuh.attachDefaultHandlers();
		
		//Add contextual menu ability
		DragProxyContextualMenu dpm = new DragProxyContextualMenu(this);
		this.addContextualMenuHandler(new ContextualMenuHandler(this));

		this.defaultHandlers	= new ConnectableElementDefaultHandlers(this);
		this.defaultHandlers.attachDefaultHandlers();
		
		this.addResizeHandler(this);
		
		this.refreshMagnets();

	}
	
	
	@Override
	protected void init() {
		super.init();
		
		this.label	  = this.getDefinitionPanel().getCanvas().createText(Pool.DEFAULT_WIDTH/2, ((Pool.DEFAULT_HEIGHT/2)/2), "");
		this.getGroup().appendChild(label);
	}
	
		@Override
		public SVGElement getMainShape() {
			
		if (boundary==null){
			
			boundary = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, Pool.DEFAULT_WIDTH, (Pool.DEFAULT_HEIGHT/2));
			boundary.setFillColour("white");
			boundary.setStokeColour("black");
		
		}
		

		return boundary;
	}

	@Override
	public void refresh() {
		label.setX(this.getWidth()/2);
		label.setY(this.getHeight()/2);			
		
		refreshMagnets();
	}

	@Override
	public String getName() {
		return "Collapsed Pool";
	}

	@Override
	public void addConnectableHandler(IConnectableHandler connectableHandler) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void addIncommingConnector(IConnector connector) {
		this.incommingConnectors.add(connector);
	}

	@Override
	public void addOutgoingConnector(IConnector connector) {
		this.outgoingConnectors.add(connector);
	}

	@Override
	public IConnectableElementDefaulHandlers getDefaultHandlers() {
		return defaultHandlers;
	}

	@Override
	public IGraph getGraph() {
		return this.getUIPanel();
	}

	@Override
	public HashSet<IConnector> getIncommingConnectors() {
		return incommingConnectors;
	}

	@Override
	public HashSet<IMagnet> getMagnets() {
		return magnets;
	}

	@Override
	public HashSet<IConnector> getOutgoingConnectors() {
		return outgoingConnectors;
	}

	
	
	
	@Override
	public void refreshMagnets() {
	
		
		float topLeftMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft() +this.getUIPanel().getScrollLeft();
		float topLeftMY = this.getAbsoluteTop() - this.getUIPanel().getAbsoluteTop() +this.getUIPanel().getScrollTop(); 
		
		float topMiddleMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft() + (this.getWidth()) / 2 + this.getUIPanel().getScrollLeft();
		float topMiddleMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+ this.getUIPanel().getScrollTop();
		
		float topRightMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft() + (this.getWidth())+ this.getUIPanel().getScrollLeft();
		float topRightMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+ this.getUIPanel().getScrollTop();
		
		float rightMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+this.getWidth()+ this.getUIPanel().getScrollLeft();
		float rightMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+(this.getHeight()/2)+ this.getUIPanel().getScrollTop();
		
		float leftMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+ this.getUIPanel().getScrollLeft();
		float leftMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+(this.getHeight()/2)+ this.getUIPanel().getScrollTop();
		
		float bottomLeftMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+ this.getUIPanel().getScrollLeft();
		float bottomLeftMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+this.getHeight()+ this.getUIPanel().getScrollTop();
 	
		float bottomRightMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+this.getWidth()+ this.getUIPanel().getScrollLeft();
		float bottomRightMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+this.getHeight()+ this.getUIPanel().getScrollTop();
		
		float bottomMiddleMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+(this.getWidth()/2)+ this.getUIPanel().getScrollLeft();
		float bottomMiddleMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+this.getHeight()+ this.getUIPanel().getScrollTop();
		
		if (this.topLeftM ==null && this.topMiddleM ==null) {
			
			this.topLeftM = new MagnetElement(this);
			this.topLeftM.getElement().setId(DOM.createUniqueId());
			this.topLeftM.setRelativeX(topLeftMX);
			this.topLeftM.setRelativeY(topLeftMY);
			
			
			this.topMiddleM = new MagnetElement(this);
			this.topMiddleM.getElement().setId(DOM.createUniqueId());
			this.topMiddleM.setRelativeX(topMiddleMX);
			this.topMiddleM.setRelativeY(topMiddleMY);
			
			this.topRightM = new MagnetElement(this);
			this.topRightM.getElement().setId(DOM.createUniqueId());
			this.topRightM.setRelativeX(topRightMX);
			this.topRightM.setRelativeY(topRightMY);
			
			this.rightM = new MagnetElement(this);
			this.rightM.getElement().setId(DOM.createUniqueId());
			this.rightM.setRelativeX(rightMX);
			this.rightM.setRelativeY(rightMY);
			
			this.leftM = new MagnetElement(this);
			this.leftM.getElement().setId(DOM.createUniqueId());
			this.leftM.setRelativeX(leftMX);
			this.leftM.setRelativeY(leftMY);
			
			this.bottomLeftM = new MagnetElement(this);
			this.bottomLeftM.getElement().setId(DOM.createUniqueId());
			this.bottomLeftM.setRelativeX(bottomLeftMX);
			this.bottomLeftM.setRelativeY(bottomLeftMY);

			this.bottomRightM = new MagnetElement(this);
			this.bottomRightM.getElement().setId(DOM.createUniqueId());
			this.bottomRightM.setRelativeX(bottomRightMX);
			this.bottomRightM.setRelativeY(bottomRightMY);
			
			this.bottomMiddleM = new MagnetElement(this);
			this.bottomMiddleM.getElement().setId(DOM.createUniqueId());
			this.bottomMiddleM.setRelativeX(bottomMiddleMX);
			this.bottomMiddleM.setRelativeY(bottomMiddleMY);
			
			
			this.magnets.add(topLeftM);
			this.magnets.add(topMiddleM);
			this.magnets.add(topRightM);
			this.magnets.add(rightM);
			this.magnets.add(leftM);
			this.magnets.add(bottomLeftM);
			this.magnets.add(bottomRightM);
			this.magnets.add(bottomMiddleM);
			
		} else {
			
			this.topLeftM.setRelativeX(topLeftMX);
			this.topLeftM.setRelativeY(topLeftMY);				
			
			this.topMiddleM.setRelativeX(topMiddleMX);
			this.topMiddleM.setRelativeY(topMiddleMY);
		
			this.topRightM.setRelativeX(topRightMX);
			this.topRightM.setRelativeY(topRightMY);

			this.rightM.setRelativeX(rightMX);
			this.rightM.setRelativeY(rightMY);
		
			this.leftM.setRelativeX(leftMX);
			this.leftM.setRelativeY(leftMY);
			
			this.bottomLeftM.setRelativeX(bottomLeftMX);
			this.bottomLeftM.setRelativeY(bottomLeftMY);
			
			this.bottomRightM.setRelativeX(bottomRightMX);
			this.bottomRightM.setRelativeY(bottomRightMY);
		
			this.bottomMiddleM.setRelativeX(bottomMiddleMX);
			this.bottomMiddleM.setRelativeY(bottomMiddleMY);
		}
		
		
		for(IMagnet m:this.getMagnets()){
			
			for(IConnectorPoint p :m.getConnectorPoints()){
				p.getConnector().refresh();
			}
			
		}
		
	}

	@Override
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		
		HashSet<Class<? extends IDraggableElement>> acceptedType = new HashSet<Class<? extends IDraggableElement>>();
		
		acceptedType.add(MessageFlow.class);
		
		return acceptedType;
	}



	@Override
	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			this.editorModel = GWT.create(PoolEditorModel.class);
		}
		
		return editorModel;
	}

	@Override
	public IDiagramElementSyntaxModelBinder getSyntaxModelBinder() {
		
		if (poolSyntaxBinder==null){
			this.poolSyntaxBinder = new PoolSyntaxModelBinder();
		}
		
		return poolSyntaxBinder;
	}

	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		
		//if a message flow is dropped from a HasMenuDragProxy connect  
		if (event.getDraggableElement() instanceof DraggableProxy){
			
			DraggableProxy dp = (DraggableProxy) event.getDraggableElement();
			
			if (dp.getHasDraggableElementProxy() instanceof IHasMenuDragProxy){
				
				IHasMenuDragProxy hmdp = (IHasMenuDragProxy) (dp.getHasDraggableElementProxy());
				
				if (dp.getHasDraggableElementProxy().getIUIElementType()==MessageFlow.class){
					
					MessageFlow mf = (MessageFlow) getUIPanel().getElementFactory().getElement(MessageFlow.class);
					getUIPanel().addUIElement(mf);
					
					mf.connect((IConnectableElement) hmdp.getContextualMenuSubject(), this);
					
				}
				
			}
			
			
		}
		
	}

	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onOut(IOutEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onOver(IOverEvent event) {
		// TODO Auto-generated method stub
		
	}

	
	@Override
	public void removeFromParent() {
		super.removeFromParent();
		
		
		if (topLeftM!=null) topLeftM.removeFromParent();
		if (topMiddleM!=null) topMiddleM.removeFromParent();
		if (topRightM!=null) topRightM.removeFromParent();
		if (leftM!=null) leftM.removeFromParent();
		if (rightM!=null) rightM.removeFromParent();
		if (bottomLeftM!=null) bottomLeftM.removeFromParent();
		if (bottomMiddleM!=null) bottomMiddleM.removeFromParent();
		if (bottomRightM!=null) bottomRightM.removeFromParent();
		
	}


	@Override
	public void addResizeHandler(IResizeHandler handler) {
		handlerManager.addHandler(ResizeStartEvent.TYPE,(ResizeHandler) handler);
		handlerManager.addHandler(ResizeStopEvent.TYPE,(ResizeHandler) handler);
		handlerManager.addHandler(ResizeEvent.TYPE,(ResizeHandler) handler);
	}


	@Override
	public IPoint getNorthEastPoint() {
		// TODO Auto-generated method stub
		return null;
	}


	public IResizableElementDefaultHandlers getResizableDefaultHandlers() {

		return resizableDefaultHanders;
	}


	@Override
	public IPoint getSouthWestPoint() {
		// TODO Auto-generated method stub
		return null;
	}


	public boolean isResizableOnNorthEast() {
		return false;
	}

	public boolean isResizableOnNorthWest() {
		return false;
	}

	public boolean isResizableOnSouthEast() {
		return true;
	}

	public boolean isResizableOnSouthWest() {
		return false;
	}


	@Override
	public void onResize(IResizeEvent event) {
	}


	@Override
	public void onStart(IResizeStartEvent event) {

	}


	@Override
	public void onStop(IResizeStopEvent event) {
		
		label.setX(this.getWidth()/2);
		label.setY(this.getHeight()/2);

	}


	@Override
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		handlerManager.addHandler(ProxyDragStartEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragMoveEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragStopEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedAfterDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedAfterDropEvent.TYPE, handler);
	}


	@Override
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		
		LinkedHashSet<IHasMenuDragProxy> dps = new LinkedHashSet<IHasMenuDragProxy>();
		
		MessageFlowMenuDragProxy m = new MessageFlowMenuDragProxy(getUIPanel());
		m.setSmallIcon(true);
		m.setLabelVisible(false);
		
		dps.add(m);
		
		return dps;
	}


	@Override
	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}



	
}
